/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.dispatch;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.internal.api.portal.PortalManager;
import com.atlassian.servicedesk.plugins.notifications.internal.dao.NotificationBatchQueueEntry;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationMessageMetaData;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class EmailSenderNameCreator {
    private final UserManager userManager;
    private final PortalManager portalManager;

    @Autowired
    public EmailSenderNameCreator(UserManager userManager, PortalManager portalManager) {
        this.userManager = userManager;
        this.portalManager = portalManager;
    }

    Either<AnError, String> determineSenderName(ApplicationUser recipient, Option<ApplicationUser> authorOption, Project project) {
        return (Either)authorOption.filter(eventInitiator -> !eventInitiator.equals((Object)recipient)).fold(() -> this.retrieveFromNameFromPortal(project), eventInitiator -> Either.right((Object)eventInitiator.getDisplayName()));
    }

    Either<AnError, String> determineSenderName(NotificationMessageMetaData metaData, Collection<NotificationBatchQueueEntry> entries) {
        Option<ApplicationUser> authorOpt = this.retrieveAuthor(entries);
        return this.determineSenderName(metaData.getRecipient(), authorOpt, metaData.getProject());
    }

    private Option<ApplicationUser> retrieveAuthor(Collection<NotificationBatchQueueEntry> entries) {
        return this.areAllFromTheSameAuthor(entries).map(arg_0 -> ((UserManager)this.userManager).getUserById(arg_0)).flatMap(userOptional -> Option.option(userOptional.orElse(null)));
    }

    private Option<Long> areAllFromTheSameAuthor(Collection<NotificationBatchQueueEntry> entries) {
        Set authorIds = entries.stream().map(NotificationBatchQueueEntry::getAuthorId).collect(Collectors.toSet());
        if (authorIds.size() == 1) {
            return (Option)authorIds.iterator().next();
        }
        return Option.none();
    }

    private Either<AnError, String> retrieveFromNameFromPortal(Project project) {
        return this.portalManager.getPortalByProject(project).map(Portal::getName);
    }
}

