/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.defaultrules.migration;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.upgrade.task.NotificationDefaultRuleDescriptor;
import com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.upgrade.task.NotificationDefaultRuleManager;
import io.atlassian.fugue.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationDefaultRuleGenerator {
    private final NotificationDefaultRuleManager notificationDefaultRuleManager;

    @Autowired
    public NotificationDefaultRuleGenerator(NotificationDefaultRuleManager notificationDefaultRuleManager) {
        this.notificationDefaultRuleManager = notificationDefaultRuleManager;
    }

    public Either<AnError, List<RuleSet>> createMissingRules(ApplicationUser user, Project project, List<NotificationDefaultRuleDescriptor> notificationDefaultRuleDescriptorList, boolean enableRules) {
        return this.retrieveMissingRules(project, notificationDefaultRuleDescriptorList).flatMap(notificationDefaultRuleDescriptors -> this.createRulesFromDescriptorList(user, project, (List<NotificationDefaultRuleDescriptor>)notificationDefaultRuleDescriptors, enableRules));
    }

    Either<AnError, List<RuleSet>> createRulesFromDescriptorList(ApplicationUser user, Project project, List<NotificationDefaultRuleDescriptor> notificationDefaultRuleDescriptorList, boolean enableRules) {
        ArrayList<Object> createdRules = new ArrayList<Object>();
        for (NotificationDefaultRuleDescriptor descriptor : notificationDefaultRuleDescriptorList) {
            Either<AnError, RuleSet> ruleCreationResult = this.notificationDefaultRuleManager.createSystemRule(user, project, descriptor, enableRules);
            if (ruleCreationResult.isLeft()) {
                return Either.left((Object)ruleCreationResult.left().get());
            }
            createdRules.add(ruleCreationResult.right().get());
        }
        return Either.right(createdRules);
    }

    public Either<AnError, List<NotificationDefaultRuleDescriptor>> retrieveMissingRules(Project project, List<NotificationDefaultRuleDescriptor> notificationDefaultRuleDescriptors) {
        Either<AnError, List<RuleSet>> existingDefaultRules = this.notificationDefaultRuleManager.getAllSystemRules(project);
        return existingDefaultRules.map(this::ruleSetNames).map(existingRuleNames -> this.filterNonPersistedSystemRules((Set<String>)existingRuleNames, notificationDefaultRuleDescriptors));
    }

    private List<NotificationDefaultRuleDescriptor> filterNonPersistedSystemRules(Set<String> existingRuleNames, List<NotificationDefaultRuleDescriptor> notificationDefaultRuleDescriptors) {
        return notificationDefaultRuleDescriptors.stream().filter(ruleDescriptor -> this.isNonPersistedRule(existingRuleNames, (NotificationDefaultRuleDescriptor)ruleDescriptor)).collect(Collectors.toList());
    }

    private boolean isNonPersistedRule(Set<String> existingRuleNames, NotificationDefaultRuleDescriptor notificationDefaultRuleDescriptor) {
        String ruleDescriptorName = notificationDefaultRuleDescriptor.getRuleI18nName();
        return !existingRuleNames.contains(ruleDescriptorName);
    }

    private Set<String> ruleSetNames(List<RuleSet> ruleSetList) {
        return ruleSetList.stream().map(RuleSet::getName).collect(Collectors.toSet());
    }
}

