/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.dao;

import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.plugins.notifications.internal.dao.NotificationBatchQueueEntry;
import com.atlassian.servicedesk.plugins.notifications.internal.dao.NotificationBatchQueueEntryBuilder;
import com.atlassian.servicedesk.plugins.notifications.internal.dao.schema.querydsl.Tables;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Component;

@Component
public class NotificationBatchQueueDao {
    public List<NotificationBatchQueueEntry> fetchUnsentEntries(DatabaseConnection databaseConnection) {
        List<Tuple> result = this.fetchAndConvertUnsentEntries(databaseConnection);
        return this.convertToEntries(result);
    }

    private List<Tuple> fetchAndConvertUnsentEntries(DatabaseConnection databaseConnection) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])Tables.NOTIFICATION_BATCH_QUEUE.all()).from((Expression)Tables.NOTIFICATION_BATCH_QUEUE)).where((Predicate)Tables.NOTIFICATION_BATCH_QUEUE.SENT_TIME.isNull())).orderBy(Tables.NOTIFICATION_BATCH_QUEUE.EVENT_TIME.asc())).fetch();
    }

    private List<NotificationBatchQueueEntry> convertToEntries(List<Tuple> result) {
        return result.stream().map(this::convertToEntry).collect(Collectors.toList());
    }

    private NotificationBatchQueueEntry convertToEntry(Tuple tuple) {
        return NotificationBatchQueueEntryBuilder.newBuilder().id((Long)tuple.get(Tables.NOTIFICATION_BATCH_QUEUE.ID)).recipientId((Long)tuple.get(Tables.NOTIFICATION_BATCH_QUEUE.RECIPIENT_ID)).authorId((Long)tuple.get(Tables.NOTIFICATION_BATCH_QUEUE.AUTHOR_ID)).projectId((Long)tuple.get(Tables.NOTIFICATION_BATCH_QUEUE.PROJECT_ID)).issueId((Long)tuple.get(Tables.NOTIFICATION_BATCH_QUEUE.ISSUE_ID)).htmlContent((String)tuple.get((Expression)Tables.NOTIFICATION_BATCH_QUEUE.HTML_CONTENT)).textContent((String)tuple.get((Expression)Tables.NOTIFICATION_BATCH_QUEUE.TEXT_CONTENT)).context((Option<String>)Option.option((Object)tuple.get((Expression)Tables.NOTIFICATION_BATCH_QUEUE.CONTEXT))).eventTime(this.toLocalDate((Long)tuple.get(Tables.NOTIFICATION_BATCH_QUEUE.EVENT_TIME))).sentTime(this.toLocalDate((Long)tuple.get(Tables.NOTIFICATION_BATCH_QUEUE.SENT_TIME))).build();
    }

    public long setSendTimeStamp(Collection<Long> ids, DatabaseConnection databaseConnection) {
        if (ids.isEmpty()) {
            return 0L;
        }
        Long currentDate = this.toUtcLong(new Date());
        return databaseConnection.update((RelationalPath)Tables.NOTIFICATION_BATCH_QUEUE).set(Tables.NOTIFICATION_BATCH_QUEUE.SENT_TIME, (Object)currentDate).where((Predicate)Tables.NOTIFICATION_BATCH_QUEUE.ID.in(ids)).execute();
    }

    public long deleteEntriesSentOverThirtyDaysAgo(DatabaseConnection databaseConnection) {
        return databaseConnection.delete((RelationalPath)Tables.NOTIFICATION_BATCH_QUEUE).where((Predicate)Tables.NOTIFICATION_BATCH_QUEUE.SENT_TIME.lt((Number)this.retrieveEpochThirtyDaysAgo()).and((Predicate)Tables.NOTIFICATION_BATCH_QUEUE.SENT_TIME.isNotNull())).execute();
    }

    private long retrieveEpochThirtyDaysAgo() {
        return this.toUtcLong(DateUtils.addDays((Date)new Date(), (int)-30));
    }

    public long create(List<NotificationBatchQueueEntry> entries, DatabaseConnection databaseConnection) {
        if (entries.isEmpty()) {
            return 0L;
        }
        SQLInsertClause insertClause = databaseConnection.insert((RelationalPath)Tables.NOTIFICATION_BATCH_QUEUE);
        for (NotificationBatchQueueEntry entry : entries) {
            this.addEntryToBatch(insertClause, entry);
        }
        return insertClause.execute();
    }

    private void addEntryToBatch(SQLInsertClause insertClause, NotificationBatchQueueEntry entry) {
        insertClause.set(Tables.NOTIFICATION_BATCH_QUEUE.EVENT_TIME, (Object)this.toUtcLong(entry.getEventTime())).set(Tables.NOTIFICATION_BATCH_QUEUE.RECIPIENT_ID, (Object)entry.getRecipientID()).set(Tables.NOTIFICATION_BATCH_QUEUE.AUTHOR_ID, entry.getAuthorId().getOrNull()).set((Path)Tables.NOTIFICATION_BATCH_QUEUE.HTML_CONTENT, (Object)entry.getHtmlContent()).set((Path)Tables.NOTIFICATION_BATCH_QUEUE.TEXT_CONTENT, (Object)entry.getTextContent()).set(Tables.NOTIFICATION_BATCH_QUEUE.PROJECT_ID, (Object)entry.getProjectId()).set(Tables.NOTIFICATION_BATCH_QUEUE.ISSUE_ID, entry.getIssueId().getOrNull()).set((Path)Tables.NOTIFICATION_BATCH_QUEUE.CONTEXT, entry.getContext().getOrNull()).addBatch();
    }

    private long toUtcLong(Date date) {
        return date.toInstant().toEpochMilli();
    }

    private Date toLocalDate(Long epochMillis) {
        if (epochMillis == null) {
            return null;
        }
        return Date.from(new Date(epochMillis).toInstant());
    }
}

