/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.configuration;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public enum NotificationContext {
    NO_CONTEXT(""),
    ISSUE_CONTEXT("issue"),
    COMMENT_CONTEXT("comment"),
    RESOLUTION_CHANGE_CONTEXT("resolutionchange"),
    NEW_PARTICIPANTS_CONTEXT("newparticipants"),
    NEW_APPROVERS_CONTEXT("newapprovers"),
    STATUS_CHANGE_CONTEXT("statuschange"),
    ADDED_ORGANISATION_PARTICIPANTS_CONTEXT("addedorganisations");

    private String contextName;

    private NotificationContext(String contextName) {
        this.contextName = contextName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public static Option<NotificationContext> forContextName(String contextName) {
        return Option.option((Object)((Object)NotificationContext.asList().stream().filter(context -> context.contextName.equals(contextName)).findFirst().orElseGet(() -> null)));
    }

    public static Set<NotificationContext> forContextNames(Set<String> contextNames) {
        Set providedContexts = contextNames.stream().map(NotificationContext::forContextName).filter(Maybe::isDefined).map(Maybe::get).collect(Collectors.toSet());
        providedContexts.add(NO_CONTEXT);
        return Collections.unmodifiableSet(providedContexts);
    }

    public static Set<NotificationContext> asSet() {
        return ImmutableSet.copyOf(NotificationContext.asList());
    }

    private static List<NotificationContext> asList() {
        return ImmutableList.copyOf((Object[])NotificationContext.values());
    }
}

