/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.configuration;

import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationContext;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationVariable;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Option;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public enum ContentVariable implements NotificationVariable
{
    ISSUE_DESCRIPTION(NotificationContext.ISSUE_CONTEXT, "issue.description", "sd.notification.variables.issue.description"),
    ISSUE_KEY(NotificationContext.ISSUE_CONTEXT, "issue.key", "sd.notification.variables.issue.key"),
    ISSUE_SUMMARY(NotificationContext.ISSUE_CONTEXT, "issue.summary", "sd.notification.variables.issue.summary"),
    ISSUE_REPORTER(NotificationContext.ISSUE_CONTEXT, "issue.reporter.name", "sd.notification.variables.issue.reporter"),
    ISSUE_RESOLUTION(NotificationContext.ISSUE_CONTEXT, "issue.resolution", "sd.notification.variables.issue.resolution"),
    COMMENT_CONTENT(NotificationContext.COMMENT_CONTEXT, "comment", "sd.notification.variables.comment.content"),
    COMMENT_UNFORMATTED_CONTENT(NotificationContext.COMMENT_CONTEXT, "comment.unformatted", "sd.notification.variables.comment.unformatted.content"),
    RECIPIENT_NAME(NotificationContext.NO_CONTEXT, "recipient.name", "sd.notification.variables.recipient.name"),
    REQUEST_LINK(NotificationContext.ISSUE_CONTEXT, "issue.request.url", "sd.notification.variables.issue.request.url"),
    REQUEST_URL(NotificationContext.ISSUE_CONTEXT, "request.url", "sd.notification.variables.issue.request.url"),
    REQUEST_RESOLUTION_UPDATE(NotificationContext.RESOLUTION_CHANGE_CONTEXT, "issue.request.resolution.update", "sd.notification.variables.issue.request.resolution.change"),
    REQUEST_STATUS_UPDATE(NotificationContext.STATUS_CHANGE_CONTEXT, "issue.request.status.update", "sd.notification.variables.issue.request.status.update"),
    REQUEST_STATUS_UNFORMATTED(NotificationContext.ISSUE_CONTEXT, "issue.request.status.unformatted", "sd.notification.variables.issue.request.status.unformatted"),
    REQUEST_STATUS_OLD(NotificationContext.ISSUE_CONTEXT, "issue.request.status", "sd.notification.variables.issue.request.status"),
    REQUEST_STATUS(NotificationContext.ISSUE_CONTEXT, "request.status", "sd.notification.variables.issue.request.status"),
    EVENT_USER_NAME(NotificationContext.NO_CONTEXT, "event.user.name", "sd.notification.variables.event.user.name"),
    PROJECT_PORTAL_NAME(NotificationContext.NO_CONTEXT, "project.portal.name", "sd.notification.variables.portal.name"),
    PORTAL_NAME(NotificationContext.NO_CONTEXT, "portal.name", "sd.notification.variables.portal.name");

    private NotificationContext context;
    private String variable;
    private String nameI18nKey;

    private ContentVariable(NotificationContext context, String variable, String nameI18nKey) {
        this.context = context;
        this.variable = variable;
        this.nameI18nKey = nameI18nKey;
    }

    @Override
    public String getVariable() {
        return this.variable;
    }

    @Override
    public NotificationContext getContext() {
        return this.context;
    }

    @Override
    public String getNameI18nKey() {
        return this.nameI18nKey;
    }

    public static Option<NotificationVariable> forVariable(String variable) {
        return Option.option((Object)ContentVariable.allValuesAsList().stream().filter(notificationVariable -> notificationVariable.getVariable().equals(variable)).findFirst().orElseGet(() -> null));
    }

    public static Set<ContentVariable> variablesAvailableInContexts(Set<NotificationContext> contexts) {
        return ContentVariable.allValuesAsSet().stream().filter(variable -> contexts.contains((Object)variable.getContext())).collect(Collectors.toSet());
    }

    public static Set<ContentVariable> allValuesAsSet() {
        return ImmutableSet.copyOf((Object[])ContentVariable.values());
    }

    private static List<ContentVariable> allValuesAsList() {
        return Collections.unmodifiableList(Arrays.asList(ContentVariable.values()));
    }
}

