/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.upgrade.task;

import com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.upgrade.task.NotificationDefaultRuleIfCondition;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationRecipientType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class NotificationDefaultRuleDescriptor {
    private final String ruleI18nName;
    private final String whenModuleKey;
    private final List<NotificationDefaultRuleIfCondition> ifConditions;
    private final List<NotificationRecipientType> recipients;
    private final String contentI18nKey;
    private final boolean excludeInitiator;
    private final String analyticsSuffix;
    private final boolean enableByDefault;

    private NotificationDefaultRuleDescriptor(String ruleI18nName, String whenModuleKey, List<NotificationDefaultRuleIfCondition> ifConditions, List<NotificationRecipientType> recipients, String contentI18nKey, boolean excludeInitiator, String analyticsSuffix, boolean enableByDefault) {
        this.ruleI18nName = ruleI18nName;
        this.whenModuleKey = whenModuleKey;
        this.ifConditions = ifConditions;
        this.recipients = recipients;
        this.contentI18nKey = contentI18nKey;
        this.excludeInitiator = excludeInitiator;
        this.analyticsSuffix = analyticsSuffix;
        this.enableByDefault = enableByDefault;
    }

    public String getRuleI18nName() {
        return this.ruleI18nName;
    }

    String getWhenModuleKey() {
        return this.whenModuleKey;
    }

    List<NotificationDefaultRuleIfCondition> getIfConditions() {
        return this.ifConditions;
    }

    List<NotificationRecipientType> getRecipients() {
        return this.recipients;
    }

    boolean excludeInitiator() {
        return this.excludeInitiator;
    }

    String getContentI18nKey() {
        return this.contentI18nKey;
    }

    String getAnalyticsSuffix() {
        return this.analyticsSuffix;
    }

    boolean enableByDefault() {
        return this.enableByDefault;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(NotificationDefaultRuleDescriptor descriptor) {
        Builder builder = new Builder().analyticsSuffix(descriptor.getAnalyticsSuffix()).contentI18nKey(descriptor.getContentI18nKey()).enableByDefault(descriptor.enableByDefault()).excludeInitiator(descriptor.excludeInitiator()).recipients(descriptor.getRecipients()).ruleI18nName(descriptor.getRuleI18nName()).whenModuleKey(descriptor.getWhenModuleKey());
        descriptor.getIfConditions().forEach(builder::ifCondition);
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.ruleI18nName, this.whenModuleKey, this.ifConditions, this.recipients, this.contentI18nKey, this.excludeInitiator, this.analyticsSuffix, this.enableByDefault);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationDefaultRuleDescriptor that = (NotificationDefaultRuleDescriptor)o;
        return this.ruleI18nName.equals(that.getRuleI18nName()) && this.whenModuleKey.equals(that.getWhenModuleKey()) && this.ifConditions.equals(that.getIfConditions()) && this.recipients.equals(that.getRecipients()) && this.excludeInitiator == that.excludeInitiator() && this.analyticsSuffix.equals(that.getAnalyticsSuffix()) && this.enableByDefault == that.enableByDefault();
    }

    public static class Builder {
        private String ruleI18nName = "";
        private String whenModuleKey = "";
        private List<NotificationDefaultRuleIfCondition> ifConditions = new ArrayList<NotificationDefaultRuleIfCondition>();
        private List<NotificationRecipientType> recipients = new ArrayList<NotificationRecipientType>();
        private String contentI18nKey = "";
        private boolean excludeInitiator = false;
        private String analyticsSuffix = "";
        private boolean enableByDefault = true;

        Builder ruleI18nName(String ruleI18nName) {
            this.ruleI18nName = ruleI18nName;
            return this;
        }

        Builder whenModuleKey(String whenModuleKey) {
            this.whenModuleKey = whenModuleKey;
            return this;
        }

        Builder ifCondition(NotificationDefaultRuleIfCondition ifCondition) {
            this.ifConditions.add(ifCondition);
            return this;
        }

        Builder recipients(List<NotificationRecipientType> recipients) {
            this.recipients = recipients;
            return this;
        }

        Builder excludeInitiator(boolean excludeInitiator) {
            this.excludeInitiator = excludeInitiator;
            return this;
        }

        Builder enableByDefault(boolean enableOnStartup) {
            this.enableByDefault = enableOnStartup;
            return this;
        }

        Builder contentI18nKey(String contentI18nKey) {
            this.contentI18nKey = contentI18nKey;
            return this;
        }

        Builder analyticsSuffix(String analyticsSuffix) {
            this.analyticsSuffix = analyticsSuffix;
            return this;
        }

        public NotificationDefaultRuleDescriptor build() {
            return new NotificationDefaultRuleDescriptor(this.ruleI18nName, this.whenModuleKey, this.ifConditions, this.recipients, this.contentI18nKey, this.excludeInitiator, this.analyticsSuffix, this.enableByDefault);
        }
    }
}

