/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.batching;

import com.atlassian.servicedesk.internal.api.util.SoyTemplateRenderer;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BatchContentRenderer {
    private static final String PARAMETER_KEY_NOTIFICATIONS = "notifications";
    private static final String TEMPLATE_HTML = "ServiceDesk.Internal.Notifications.Feature.Batching.Templates.Content.html";
    private static final String TEMPLATE_TEXT = "ServiceDesk.Internal.Notifications.Feature.Batching.Templates.Content.text";
    private final SoyTemplateRenderer soyTemplateRenderer;

    @Autowired
    public BatchContentRenderer(SoyTemplateRenderer soyTemplateRenderer) {
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    public String renderContentAsHtml(List<String> contentParts) {
        return this.renderContent(TEMPLATE_HTML, contentParts);
    }

    public String renderContentAsText(List<String> contentParts) {
        return this.renderContent(TEMPLATE_TEXT, contentParts);
    }

    private String renderContent(String templateName, List<String> contentParts) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put(PARAMETER_KEY_NOTIFICATIONS, contentParts);
        return this.soyTemplateRenderer.render("com.atlassian.servicedesk.servicedesk-notifications-plugin:soy", templateName, parameters);
    }
}

