/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.automation.then;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageManager;
import com.atlassian.servicedesk.internal.api.lingo.response.Lingo;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.ThenActionValidator;
import com.atlassian.servicedesk.plugins.notifications.internal.automation.then.configuration.ConfigurationHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.automation.then.configuration.SendActionConfiguration;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.ContentVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationContext;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationRecipientType;
import com.atlassian.servicedesk.plugins.notifications.internal.recipients.NotificationRecipientConfiguration;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableResolutionManager;
import com.atlassian.util.concurrent.Assertions;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SendActionValidator
implements ThenActionValidator {
    private static final int CONTENT_MAX_LENGTH = 10000;
    private static final String SEND_NOTIFICATION_RECIPIENTS_FIELD_NAME = "automation-servicedesk-send-notification-to-field";
    private static final String SEND_NOTIFICATION_CONTENT_FIELD_NAME = "content";
    private final VariableResolutionManager variableResolutionManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final ConfigurationHelper configurationHelper;
    private final FeatureManager featureManager;
    private final LingoProjectLanguageManager lingoProjectLanguageManager;

    @Autowired
    public SendActionValidator(VariableResolutionManager variableResolutionManager, I18nHelper.BeanFactory i18nFactory, ConfigurationHelper configurationHelper, FeatureManager featureManager, LingoProjectLanguageManager lingoProjectLanguageManager) {
        this.variableResolutionManager = variableResolutionManager;
        this.i18nFactory = i18nFactory;
        this.configurationHelper = configurationHelper;
        this.featureManager = featureManager;
        this.lingoProjectLanguageManager = lingoProjectLanguageManager;
    }

    public ValidationResult validate(@Nonnull ThenActionValidator.ThenActionValidationParam thenActionValidationParam) {
        I18nHelper i18nHelper = this.i18nFactory.getInstance(thenActionValidationParam.getUserToValidateWith());
        ConfigurationData configuration = thenActionValidationParam.getConfiguration().getData();
        Set<NotificationContext> providedContexts = this.retrieveProvidedContexts(thenActionValidationParam);
        return this.validate(i18nHelper, configuration, providedContexts);
    }

    public ValidationResult validate(ApplicationUser user, ConfigurationData configuration, Set<String> provides) {
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        Set<NotificationContext> providedContexts = NotificationContext.forContextNames(provides);
        return this.validate(i18nHelper, configuration, providedContexts);
    }

    private Set<NotificationContext> retrieveProvidedContexts(ThenActionValidator.ThenActionValidationParam thenActionValidationParam) {
        Set provides = thenActionValidationParam.getProvides();
        return NotificationContext.forContextNames(provides);
    }

    private ValidationResult validate(I18nHelper i18nHelper, ConfigurationData configuration, Set<NotificationContext> providedContexts) {
        return (ValidationResult)this.configurationHelper.configurationDataToModel(configuration).fold(error -> ValidationResult.FAILED((List)Lists.newArrayList((Object[])new String[]{error.getMessage().getMessage()})), sendActionConfiguration -> this.validateConfiguration(i18nHelper, (SendActionConfiguration)sendActionConfiguration, providedContexts));
    }

    private ValidationResult validateConfiguration(I18nHelper i18nHelper, SendActionConfiguration configuration, Set<NotificationContext> providedContexts) {
        Either<String, Unit> recipientErrors = this.validateRecipientConfiguration(i18nHelper, configuration, providedContexts);
        List<String> contentError = this.validateContent(i18nHelper, configuration, providedContexts);
        return this.getValidationResultFromError(recipientErrors, contentError);
    }

    private Either<String, Unit> validateRecipientConfiguration(I18nHelper i18nHelper, SendActionConfiguration sendActionConfiguration, Set<NotificationContext> providedContexts) {
        NotificationRecipientConfiguration recipients = sendActionConfiguration.getRecipientConfiguration();
        Set<NotificationRecipientType> availableRecipients = NotificationRecipientType.retrieveAvailableRecipientTypes(providedContexts);
        if (recipients.getNotificationRecipientTypes().isEmpty()) {
            return Either.left((Object)i18nHelper.getText("sd.notifications.validation.recipients.missing"));
        }
        if (availableRecipients.containsAll(recipients.getNotificationRecipientTypes())) {
            return Either.right((Object)Unit.Unit());
        }
        return Either.left((Object)this.formatRecipientNames(i18nHelper, recipients.getNotificationRecipientTypes(), availableRecipients));
    }

    private List<String> validateContent(I18nHelper i18nHelper, SendActionConfiguration configurationData, Set<NotificationContext> providedContexts) {
        ArrayList<String> errors = new ArrayList<String>();
        this.validateAtLeastOneLanguageHasContent(i18nHelper, configurationData).forEach(errors::add);
        configurationData.getContent().getContentAsMap().forEach((locale, translation) -> errors.addAll(this.validateTranslation(i18nHelper, configurationData, providedContexts, (Locale)locale, (String)translation)));
        return errors;
    }

    private List<String> validateTranslation(I18nHelper i18nHelper, SendActionConfiguration configurationData, Set<NotificationContext> providedContexts, Locale locale, String translation) {
        String localePrefix = locale.getDisplayName(i18nHelper.getLocale());
        Function<String, String> errorFormatter = error -> localePrefix + ": " + error;
        if (StringUtils.isNotBlank((String)translation)) {
            Option<String> systemTranslation = this.retrieveSystemI18nTranslation(configurationData, locale);
            return this.validateContent(i18nHelper, translation, providedContexts, errorFormatter, systemTranslation);
        }
        if (configurationData.isDefaultRule()) {
            String error2 = errorFormatter.apply(i18nHelper.getText("sd.notifications.validation.default.rule.content.blank"));
            return Lists.newArrayList((Object[])new String[]{error2});
        }
        return Collections.emptyList();
    }

    private Option<String> retrieveSystemI18nTranslation(SendActionConfiguration configurationData, Locale locale) {
        Option i18nKeyOption = configurationData.getLingo().flatMap(Lingo::getSystemI18n);
        return i18nKeyOption.map(i18nKey -> this.i18nFactory.getInstance(locale).getText(i18nKey));
    }

    private Option<String> validateAtLeastOneLanguageHasContent(I18nHelper i18nHelper, SendActionConfiguration configurationData) {
        if (configurationData.isDefaultRule()) {
            return Option.none();
        }
        if (this.featureManager.isEnabled("sd.custom.email.notifications.manage.language")) {
            if (this.areAllEnabledLanguagesBlank(configurationData)) {
                return Option.some((Object)i18nHelper.getText("sd.notifications.validation.content.missing.multi.language.enabled"));
            }
        } else if (configurationData.getContent().getContentAsMap().values().stream().allMatch(StringUtils::isBlank)) {
            return Option.some((Object)i18nHelper.getText("sd.notifications.validation.content.missing.multi.language"));
        }
        return Option.none();
    }

    private boolean areAllEnabledLanguagesBlank(SendActionConfiguration configurationData) {
        Set enabledLocales = this.lingoProjectLanguageManager.retrieveProjectLocales(configurationData.getProjectId(), false);
        return configurationData.getContent().getContentAsMap().entrySet().stream().filter(entry -> enabledLocales.contains(entry.getKey())).allMatch(entry -> StringUtils.isBlank((String)((String)entry.getValue())));
    }

    private List<String> validateContent(I18nHelper i18nHelper, String content, Set<NotificationContext> providedContexts, Function<String, String> errorFormatter, Option<String> systemI18nTranslation) {
        if (systemI18nTranslation.isDefined() && Objects.equals(content, systemI18nTranslation.get())) {
            return Collections.emptyList();
        }
        ArrayList<String> errors = new ArrayList<String>();
        errors.addAll(this.validateContentLength(i18nHelper, content));
        errors.addAll(this.validateContentVariables(i18nHelper, content, providedContexts));
        return errors.stream().map(errorFormatter).collect(Collectors.toList());
    }

    private List<String> validateContentLength(I18nHelper i18nHelper, String content) {
        ArrayList<String> errors = new ArrayList<String>();
        if (content.length() > 10000) {
            errors.add(i18nHelper.getText("sd.notifications.validation.content.too.long", Integer.toString(10000), Integer.toString(content.length())));
        }
        return errors;
    }

    private List<String> validateContentVariables(I18nHelper i18nHelper, String content, Set<NotificationContext> providedContexts) {
        Set<String> invalidVariables = this.variableResolutionManager.resolveVariables(content, ContentVariable.variablesAvailableInContexts(providedContexts)).getInvalidVariables();
        return this.createErrorForInvalidVariables(i18nHelper, invalidVariables);
    }

    private List<String> createErrorForInvalidVariables(I18nHelper i18nHelper, Set<String> variables) {
        ArrayList<String> errors = new ArrayList<String>();
        if (!variables.isEmpty()) {
            errors.add(i18nHelper.getText("sd.notifications.validation.content.invalid.variable", this.formatMultipleNames(i18nHelper, Lists.newArrayList(variables))));
        }
        return errors;
    }

    private ValidationResult getValidationResultFromError(@Nonnull Either<String, Unit> recipientErrors, @Nonnull List<String> contentErrors) {
        Assertions.notNull((String)"recipientErrors", recipientErrors);
        Assertions.notNull((String)"contentErrors", contentErrors);
        if (recipientErrors.isLeft() || !contentErrors.isEmpty()) {
            return this.createValidationResultFailed(recipientErrors, contentErrors);
        }
        return ValidationResult.PASSED();
    }

    private ValidationResult createValidationResultFailed(@Nonnull Either<String, Unit> recipientErrors, @Nonnull List<String> contentErrors) {
        CopyOnWriteMap validationErrors = CopyOnWriteMap.newHashMap();
        if (recipientErrors.isLeft()) {
            validationErrors.put(SEND_NOTIFICATION_RECIPIENTS_FIELD_NAME, Lists.newArrayList((Object[])new String[]{(String)recipientErrors.left().get()}));
        }
        if (!contentErrors.isEmpty()) {
            validationErrors.put(SEND_NOTIFICATION_CONTENT_FIELD_NAME, contentErrors);
        }
        return ValidationResult.FAILED((Map)validationErrors);
    }

    private String formatRecipientNames(I18nHelper i18nHelper, Set<NotificationRecipientType> recipients, Set<NotificationRecipientType> availableRecipients) {
        List<String> invalidRecipients = recipients.stream().filter(recipientType -> !availableRecipients.contains(recipientType)).map(NotificationRecipientType::getNameI18nKey).map(i18Name -> "'" + i18nHelper.getText(i18Name) + "'").collect(Collectors.toList());
        if (invalidRecipients.size() == 1) {
            return i18nHelper.getText("sd.notifications.validation.recipient.not.in.context", (String)invalidRecipients.get(0));
        }
        return i18nHelper.getText("sd.notifications.validation.recipients.not.in.context", this.formatMultipleNames(i18nHelper, invalidRecipients));
    }

    private String formatMultipleNames(I18nHelper i18nHelper, List<String> namesToDisplay) {
        if (namesToDisplay.size() == 1) {
            return namesToDisplay.get(0);
        }
        String allButTheLast = StringUtils.join(namesToDisplay.subList(0, Math.max(namesToDisplay.size() - 1, 0)), (String)", ");
        String lastName = namesToDisplay.get(namesToDisplay.size() - 1);
        return allButTheLast + " " + i18nHelper.getText("sd.common.words.and") + " " + lastName;
    }
}

