/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.automation.then;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.lingo.manager.LingoManager;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoInput;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoInputBuilder;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoInputBuilderFactory;
import com.atlassian.servicedesk.internal.api.lingo.response.Lingo;
import com.atlassian.servicedesk.internal.api.lingo.response.LingoTranslation;
import com.atlassian.servicedesk.plugins.automation.spi.configuration.ConfigurationProcessor;
import com.atlassian.servicedesk.plugins.notifications.internal.automation.then.configuration.ConfigurationHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.automation.then.configuration.SendActionConfiguration;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class SendActionConfigurationProcessor
implements ConfigurationProcessor {
    private final LingoManager lingoManager;
    private final LingoInputBuilderFactory lingoInputBuilderFactory;
    private final ConfigurationHelper configurationHelper;

    @Autowired
    public SendActionConfigurationProcessor(LingoManager lingoManager, LingoInputBuilderFactory lingoInputBuilderFactory, ConfigurationHelper configurationHelper) {
        this.lingoManager = lingoManager;
        this.lingoInputBuilderFactory = lingoInputBuilderFactory;
        this.configurationHelper = configurationHelper;
    }

    public Map<String, String> postLoad(Map<String, String> map) {
        if (map.isEmpty()) {
            return map;
        }
        return (Map)this.configurationHelper.configurationDataToModel(map).fold(error -> map, configuration -> (Map)configuration.getLingo().fold(() -> this.configurationHelper.replaceContentInConfiguration(map, (SendActionConfiguration)configuration), lingo -> this.addLingoInformationToConfiguration(map, (Lingo)lingo)));
    }

    private Map<String, String> addLingoInformationToConfiguration(Map<String, String> configuration, Lingo lingo) {
        Map<String, String> translations = this.transformLingoToTranslationMap(lingo);
        return this.configurationHelper.replaceContentInConfiguration(configuration, translations);
    }

    public Map<String, String> preStore(Map<String, String> configurationMap) {
        if (configurationMap.isEmpty()) {
            return configurationMap;
        }
        return (Map)this.configurationHelper.configurationDataToModel(configurationMap).fold(error -> configurationMap, configuration -> this.storeLingoAndUpdateConfiguration(configurationMap, (SendActionConfiguration)configuration));
    }

    private Map<String, String> storeLingoAndUpdateConfiguration(Map<String, String> configurationMap, SendActionConfiguration configuration) {
        return (Map)this.configurationHelper.retrieveLingoID(configurationMap).toOption().flatMap(id -> this.configurationHelper.retrieveProjectId(configurationMap)).flatMap(id -> this.storeLingo(configuration)).fold(() -> configurationMap, lingoId -> this.configurationHelper.addLingoToConfiguration(configurationMap, (Long)lingoId));
    }

    private Option<Long> storeLingo(SendActionConfiguration configuration) {
        return this.createLingoInput(configuration).toOption().flatMap(arg_0 -> ((LingoManager)this.lingoManager).storeLingo(arg_0));
    }

    private Either<AnError, LingoInput> createLingoInput(SendActionConfiguration configuration) {
        LingoInputBuilder lingoInputBuilder = (LingoInputBuilder)configuration.getLingo().fold(() -> ((LingoInputBuilderFactory)this.lingoInputBuilderFactory).newBuilder(), lingo -> this.lingoInputBuilderFactory.newBuilderWithTechnicalId(lingo.getId()));
        configuration.getContent().getContentAsMap().forEach((arg_0, arg_1) -> ((LingoInputBuilder)lingoInputBuilder).addTranslation(arg_0, arg_1));
        lingoInputBuilder.projectId(configuration.getProjectId()).category("sd.notifications.custom.email.content");
        return lingoInputBuilder.build();
    }

    private Map<String, String> transformLingoToTranslationMap(Lingo lingo) {
        return lingo.getTranslations().stream().collect(Collectors.toMap(translation -> translation.getLocale().toLanguageTag(), LingoTranslation::getContent));
    }
}

