/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.automation.then;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.internal.api.notifications.ServiceDeskNotificationSender;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionErrorHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.ThenAction;
import com.atlassian.servicedesk.plugins.notifications.internal.automation.then.SendActionHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.dispatch.NotificationMessageProcessor;
import com.atlassian.servicedesk.plugins.notifications.internal.message.RecipientNotificationMessage;
import com.atlassian.servicedesk.plugins.notifications.internal.migration.MigrationStatusChecker;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendAction
implements ThenAction {
    private static final Logger LOG = LoggerFactory.getLogger(SendAction.class);
    private static final String IS_DEFAULT_RULE = "isdefaultrule";
    private final SendActionHelper helper;
    private final NotificationMessageProcessor notificationMessageProcessor;
    private final ThenActionErrorHelper thenActionErrorHelper;
    private final ServiceDeskNotificationSender serviceDeskNotificationSender;
    private final MigrationStatusChecker migrationStatusChecker;

    public SendAction(SendActionHelper helper, NotificationMessageProcessor notificationMessageProcessor, ThenActionErrorHelper thenActionErrorHelper, ServiceDeskNotificationSender serviceDeskNotificationSender, MigrationStatusChecker migrationStatusChecker) {
        this.helper = helper;
        this.notificationMessageProcessor = notificationMessageProcessor;
        this.thenActionErrorHelper = thenActionErrorHelper;
        this.serviceDeskNotificationSender = serviceDeskNotificationSender;
        this.migrationStatusChecker = migrationStatusChecker;
    }

    public Either<ThenActionError, RuleMessage> invoke(@Nonnull ThenAction.ThenActionParam thenActionParam) {
        long startTime = System.currentTimeMillis();
        RuleMessage ruleMessage = thenActionParam.getMessage();
        ConfigurationData data = thenActionParam.getConfiguration().getData();
        if (this.shouldSendNotifications() && this.notificationsIsNotFeatureFlagged(data)) {
            Either messagesEither = StepsConverters.olderEither(this.helper.createNotificationMessages(ruleMessage, data));
            return (Either)messagesEither.fold(e -> {
                LOG.error(e.getMessage().getMessage());
                return this.thenActionErrorHelper.error(e);
            }, messages -> {
                Either<ThenActionError, RuleMessage> result = this.dispatchMessages((List<RecipientNotificationMessage>)messages, ruleMessage);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Elapsed time to generate messages: {}ms", (Object)(System.currentTimeMillis() - startTime));
                }
                return result;
            });
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Notification not eligible for sending.");
        }
        return Either.right((Object)ruleMessage);
    }

    private Either<ThenActionError, RuleMessage> dispatchMessages(List<RecipientNotificationMessage> messages, RuleMessage ruleMessage) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing notifications for {} recipients.", (Object)messages.size());
        }
        return StepsConverters.olderEither(this.notificationMessageProcessor.process(messages)).map(unit -> ruleMessage).left().flatMap(arg_0 -> ((ThenActionErrorHelper)this.thenActionErrorHelper).error(arg_0));
    }

    private boolean shouldSendNotifications() {
        return this.serviceDeskNotificationSender.isOutgoingMailConfigured();
    }

    private boolean notificationsIsNotFeatureFlagged(ConfigurationData configurationData) {
        return this.isNotDefaultRule(configurationData) || this.migrationStatusChecker.isDefaultNotificationSendingEnabled();
    }

    private boolean isNotDefaultRule(ConfigurationData data) {
        return !data.getValue(IS_DEFAULT_RULE).exists(isDefaultRule -> Objects.equals(isDefaultRule, "true"));
    }
}

