/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.automation.then;

import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.CommentMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.EventTimeMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.IssueMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.UserMessageHelper;
import com.atlassian.servicedesk.plugins.automation.modules.internal.api.rulewhen.helper.ApprovalMessageHelper;
import com.atlassian.servicedesk.plugins.automation.modules.internal.api.rulewhen.helper.OrganisationParticipantsMessageHelper;
import com.atlassian.servicedesk.plugins.automation.modules.internal.api.rulewhen.helper.ParticipantsMessageHelper;
import com.atlassian.servicedesk.plugins.automation.modules.internal.api.rulewhen.helper.ResolutionChangeMessageHelper;
import com.atlassian.servicedesk.plugins.automation.modules.internal.api.rulewhen.helper.StatusTransitionedMessageHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationMessageBuilder;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class MessageHelper {
    private final IssueMessageHelper issueMessageHelper;
    private final CommentMessageHelper commentMessageHelper;
    private final ParticipantsMessageHelper participantsMessageHelper;
    private final UserMessageHelper userMessageHelper;
    private final ApprovalMessageHelper approvalMessageHelper;
    private final ResolutionChangeMessageHelper resolutionChangeMessageHelper;
    private final EventTimeMessageHelper eventTimeMessageHelper;
    private final StatusTransitionedMessageHelper statusTransitionedMessageHelper;

    @Autowired
    public MessageHelper(IssueMessageHelper issueMessageHelper, CommentMessageHelper commentMessageHelper, ParticipantsMessageHelper participantsMessageHelper, UserMessageHelper userMessageHelper, ApprovalMessageHelper approvalMessageHelper, ResolutionChangeMessageHelper resolutionChangeMessageHelper, EventTimeMessageHelper eventTimeMessageHelper, StatusTransitionedMessageHelper statusTransitionedMessageHelper) {
        this.issueMessageHelper = issueMessageHelper;
        this.commentMessageHelper = commentMessageHelper;
        this.participantsMessageHelper = participantsMessageHelper;
        this.userMessageHelper = userMessageHelper;
        this.approvalMessageHelper = approvalMessageHelper;
        this.resolutionChangeMessageHelper = resolutionChangeMessageHelper;
        this.eventTimeMessageHelper = eventTimeMessageHelper;
        this.statusTransitionedMessageHelper = statusTransitionedMessageHelper;
    }

    void addAvailableContexts(NotificationMessageBuilder builder, RuleMessage ruleMessage) {
        this.issueMessageHelper.getIssue(ruleMessage).foreach(builder::issue);
        this.commentMessageHelper.getComment(ruleMessage).foreach(builder::comment);
        this.participantsMessageHelper.getNewParticipants(ruleMessage).foreach(builder::newParticipants);
        OrganisationParticipantsMessageHelper.getNewOrganisationParticipants((RuleMessage)ruleMessage).forEach(builder::newOrganisations);
        this.userMessageHelper.getUser(ruleMessage, "currentUser").foreach(builder::eventInitiator);
        this.approvalMessageHelper.getNewApprovers(ruleMessage).foreach(builder::newApprovers);
        this.resolutionChangeMessageHelper.getResolutionChange(ruleMessage).foreach(builder::resolutionChangeType);
        this.statusTransitionedMessageHelper.getStatusTransitioned(ruleMessage).foreach(builder::statusChange);
        builder.eventTime(this.retrieveEventTimeOrNow(ruleMessage));
    }

    private Date retrieveEventTimeOrNow(RuleMessage ruleMessage) {
        return (Date)this.eventTimeMessageHelper.getEventTime(ruleMessage).getOrElse((Object)new Date());
    }
}

