/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.analytics;

import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.plugins.notifications.internal.analytics.NotificationAnalyticsEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationAnalyticsEventHelper {
    private AnalyticsService analyticsService;

    @Autowired
    public NotificationAnalyticsEventHelper(AnalyticsService analyticsService) {
        this.analyticsService = analyticsService;
    }

    public void fireAnalyticsEvent(String eventName, Long projectId) {
        NotificationAnalyticsEvent event = new NotificationAnalyticsEvent(eventName, projectId, null, null, null);
        this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)event);
    }

    public void analyticsBatchMessageEvent(Long projectId, Integer batchSize) {
        NotificationAnalyticsEvent event = new NotificationAnalyticsEvent("servicedesk.custom.notifications.dispatch.batch.message", projectId, null, null, batchSize);
        this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)event);
    }

    public void fireMessagePreparedEvent(Long projectId, Integer recipientQuantity) {
        NotificationAnalyticsEvent event = new NotificationAnalyticsEvent("servicedesk.custom.notifications.dispatch.notification.message.prepared", projectId, recipientQuantity, null, null);
        this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)event);
    }
}

