/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.lingo.internal.visiblefortesting;

import com.atlassian.annotations.Internal;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectConfiguration;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageInput;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageInputBuilder;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageInputBuilderFactory;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageManager;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoInput;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoInputBuilder;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoInputBuilderFactory;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoQueryRequest;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoQueryRequestFactory;
import com.atlassian.servicedesk.internal.api.lingo.response.Lingo;
import com.atlassian.servicedesk.internal.api.lingo.response.LingoTranslation;
import com.atlassian.servicedesk.internal.api.visiblefortesting.LingoBackdoor;
import com.atlassian.servicedesk.internal.api.visiblefortesting.request.LingoProjLanguageRequest;
import com.atlassian.servicedesk.internal.api.visiblefortesting.request.LingoRequest;
import com.atlassian.servicedesk.internal.api.visiblefortesting.response.LingoResponse;
import com.atlassian.servicedesk.internal.api.visiblefortesting.response.LingoTranslationResponse;
import com.atlassian.servicedesk.plugins.lingo.internal.manager.LingoManagerImpl;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@Internal
class LingoBackdoorImpl
implements LingoBackdoor {
    private final LingoManagerImpl lingoManager;
    private final LingoQueryRequestFactory lingoQueryRequestBuilderFactory;
    private final LingoInputBuilderFactory lingoInputBuilderFactory;
    private final LingoProjectLanguageManager lingoProjectLanguageManager;
    private final LingoProjectLanguageInputBuilderFactory lingoProjectLanguageInputBuilderFactory;

    @Autowired
    public LingoBackdoorImpl(LingoManagerImpl lingoManager, LingoQueryRequestFactory lingoQueryRequestBuilderFactory, LingoInputBuilderFactory lingoInputBuilderFactory, LingoProjectLanguageManager lingoProjectLanguageManager, LingoProjectLanguageInputBuilderFactory lingoProjectLanguageInputBuilderFactory) {
        this.lingoManager = lingoManager;
        this.lingoQueryRequestBuilderFactory = lingoQueryRequestBuilderFactory;
        this.lingoInputBuilderFactory = lingoInputBuilderFactory;
        this.lingoProjectLanguageManager = lingoProjectLanguageManager;
        this.lingoProjectLanguageInputBuilderFactory = lingoProjectLanguageInputBuilderFactory;
    }

    public Option<LingoResponse> retrieveLingo(Option<Long> projectId, String logicalId) {
        LingoQueryRequest lingoQueryRequest = this.lingoQueryRequestBuilderFactory.createLingoQueryRequest(projectId, logicalId);
        return this.lingoManager.retrieveLingo(lingoQueryRequest).map(this::createResponse);
    }

    public Either<AnError, Option<Long>> storeLingo(LingoRequest lingoRequest) {
        return this.createInput(lingoRequest).map(this.lingoManager::storeLingo);
    }

    public Either<AnError, Option<Long>> storeProjectLanguage(LingoProjLanguageRequest request) {
        return this.createProjectLanguageInput(request).map(arg_0 -> ((LingoProjectLanguageManager)this.lingoProjectLanguageManager).storeProjectLanguages(arg_0)).map(lingoProjectConfiguration -> lingoProjectConfiguration.map(LingoProjectConfiguration::getProjectId));
    }

    private LingoResponse createResponse(Lingo lingo) {
        LingoResponse response = new LingoResponse();
        response.setId(lingo.getId());
        lingo.getCategory().forEach(arg_0 -> ((LingoResponse)response).setCategory(arg_0));
        lingo.getSystemI18n().forEach(arg_0 -> ((LingoResponse)response).setSystemI18n(arg_0));
        lingo.getLogicalId().forEach(arg_0 -> ((LingoResponse)response).setLogicalId(arg_0));
        lingo.getProjectId().foreach(arg_0 -> ((LingoResponse)response).setProjectId(arg_0));
        response.setTranslations(lingo.getTranslations().stream().map(this::createTranslationResponse).collect(Collectors.toList()));
        return response;
    }

    private LingoTranslationResponse createTranslationResponse(LingoTranslation translation) {
        LingoTranslationResponse response = new LingoTranslationResponse();
        response.setLanguage(translation.getLanguage());
        response.setLocale(translation.getLocale().toLanguageTag());
        response.setContent(translation.getContent());
        return response;
    }

    private Either<AnError, LingoInput> createInput(LingoRequest lingoRequest) {
        LingoInputBuilder builder = this.lingoInputBuilderFactory.newBuilderWithLogicalId(lingoRequest.getLogicalId());
        Option.option((Object)lingoRequest.getProjectId()).fold(() -> ((LingoInputBuilder)builder).instanceWideLingo(), arg_0 -> ((LingoInputBuilder)builder).projectId(arg_0));
        builder.systemI18n(lingoRequest.getSystemI18n());
        builder.category(lingoRequest.getCategory());
        lingoRequest.getTranslations().forEach(translation -> builder.addTranslation(Locale.forLanguageTag(translation.getLanguageTag()), translation.getContent()));
        return builder.build();
    }

    private Either<AnError, LingoProjectLanguageInput> createProjectLanguageInput(LingoProjLanguageRequest request) {
        Locale defaultLocale = Locale.forLanguageTag(request.getProjectDefaultLanguageKey());
        LingoProjectLanguageInputBuilder builder = this.lingoProjectLanguageInputBuilderFactory.newBuilder(request.getProjectId().longValue());
        request.getLanguage().entrySet().stream().collect(Collectors.toMap(entry -> Locale.forLanguageTag((String)entry.getKey()), Map.Entry::getValue)).forEach((arg_0, arg_1) -> ((LingoProjectLanguageInputBuilder)builder).addLanguage(arg_0, arg_1));
        builder.defaultLanguage(defaultLocale);
        return builder.build();
    }
}

