/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.lingo.internal.response;

import com.atlassian.servicedesk.internal.api.lingo.response.Lingo;
import com.atlassian.servicedesk.internal.api.lingo.response.LingoTranslation;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.atlassian.fugue.Option;
import java.util.Collection;

public class LingoImpl
implements Lingo {
    private final Long id;
    private final String logicalId;
    private final String category;
    private final String systemI18n;
    private final Long projectId;
    private final Collection<LingoTranslation> translations;

    @VisibleForTesting
    public LingoImpl(Long id, String logicalId, String category, String systemI18n, Long projectId, Collection<LingoTranslation> translations) {
        this.id = id;
        this.logicalId = logicalId;
        this.category = category;
        this.systemI18n = systemI18n;
        this.projectId = projectId;
        this.translations = translations;
    }

    public static Lingo withTranslations(Lingo lingo, Collection<LingoTranslation> updatedTranslations) {
        return new LingoImpl(lingo.getId(), (String)lingo.getLogicalId().getOrNull(), (String)lingo.getCategory().getOrNull(), (String)lingo.getSystemI18n().getOrNull(), (Long)lingo.getProjectId().getOrNull(), updatedTranslations);
    }

    public Long getId() {
        return this.id;
    }

    public Option<String> getLogicalId() {
        return Option.option((Object)this.logicalId);
    }

    public Option<String> getCategory() {
        return Option.option((Object)this.category);
    }

    public Option<String> getSystemI18n() {
        return Option.option((Object)this.systemI18n);
    }

    public Option<Long> getProjectId() {
        return Option.option((Object)this.projectId);
    }

    public Collection<LingoTranslation> getTranslations() {
        return this.translations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LingoImpl lingo = (LingoImpl)o;
        return Objects.equal((Object)this.id, (Object)lingo.id) && Objects.equal(this.translations, lingo.translations);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.translations});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("logicalId", (Object)this.logicalId).add("category", (Object)this.category).add("systemI18n", (Object)this.systemI18n).add("projectId", (Object)this.projectId).add("translations", this.translations).toString();
    }
}

