/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.lingo.internal.response;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.servicedesk.internal.api.lingo.response.Lingo;
import com.atlassian.servicedesk.internal.api.lingo.response.LingoTranslation;
import com.atlassian.servicedesk.plugins.lingo.internal.response.LingoImpl;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class LingoBuilder {
    private Long id;
    private String logicalId;
    private String category;
    private String systemI18n;
    @TenantAware(value=TenancyScope.TENANTED)
    private Map<Locale, LingoTranslation> translations = new HashMap<Locale, LingoTranslation>();
    private Long projectId;

    public static LingoBuilder newBuilder() {
        return new LingoBuilder();
    }

    private LingoBuilder() {
    }

    public LingoBuilder id(Long id) {
        this.id = id;
        return this;
    }

    public boolean isSameId(Long id) {
        return Objects.equals(this.id, id);
    }

    public LingoBuilder category(String category) {
        this.category = category;
        return this;
    }

    public LingoBuilder logicalId(String logicalId) {
        this.logicalId = logicalId;
        return this;
    }

    public LingoBuilder systemI18n(String systemI18n) {
        this.systemI18n = systemI18n;
        return this;
    }

    public LingoBuilder addTranslation(LingoTranslation translation) {
        this.translations.put(translation.getLocale(), translation);
        return this;
    }

    public LingoBuilder projectId(Long projectId) {
        this.projectId = projectId;
        return this;
    }

    public Lingo build() {
        return new LingoImpl(this.id, this.logicalId, this.category, this.systemI18n, this.projectId, Collections.unmodifiableList(Lists.newArrayList(this.translations.values())));
    }
}

