/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.lingo.internal.request;

import com.atlassian.servicedesk.internal.api.lingo.request.LingoInput;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoTranslationInput;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.atlassian.fugue.Option;
import java.util.List;

public class LingoInputImpl
implements LingoInput {
    private final Long technicalId;
    private final String logicalId;
    private final String category;
    private final String systemI18n;
    private final Long projectId;
    private final List<LingoTranslationInput> translations;

    @VisibleForTesting
    public LingoInputImpl(Long technicalId, String logicalId, String category, String systemI18n, Long projectId, List<LingoTranslationInput> translations) {
        this.technicalId = technicalId;
        this.logicalId = logicalId;
        this.category = category;
        this.systemI18n = systemI18n;
        this.projectId = projectId;
        this.translations = translations;
    }

    public static LingoInputImpl withTranslations(LingoInput lingoInput, List<LingoTranslationInput> updatedTranslations) {
        return new LingoInputImpl((Long)lingoInput.getTechnicalId().getOrNull(), (String)lingoInput.getLogicalId().getOrNull(), (String)lingoInput.getCategory().getOrNull(), (String)lingoInput.getSystemI18n().getOrNull(), (Long)lingoInput.getProjectId().getOrNull(), updatedTranslations);
    }

    public Option<Long> getTechnicalId() {
        return Option.option((Object)this.technicalId);
    }

    public Option<String> getLogicalId() {
        return Option.option((Object)this.logicalId);
    }

    public Option<String> getCategory() {
        return Option.option((Object)this.category);
    }

    public Option<String> getSystemI18n() {
        return Option.option((Object)this.systemI18n);
    }

    public Option<Long> getProjectId() {
        return Option.option((Object)this.projectId);
    }

    public List<LingoTranslationInput> getTranslations() {
        return this.translations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LingoInputImpl that = (LingoInputImpl)o;
        return Objects.equal((Object)this.technicalId, (Object)that.technicalId) && Objects.equal((Object)this.logicalId, (Object)that.logicalId) && Objects.equal((Object)this.category, (Object)that.category) && Objects.equal((Object)this.systemI18n, (Object)that.systemI18n) && Objects.equal((Object)this.projectId, (Object)that.projectId) && Objects.equal(this.translations, that.translations);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.technicalId, this.logicalId, this.category, this.systemI18n, this.projectId, this.translations});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("technicalId", (Object)this.technicalId).add("logicalId", (Object)this.logicalId).add("category", (Object)this.category).add("systemI18n", (Object)this.systemI18n).add("projectId", (Object)this.projectId).add("translations", this.translations).toString();
    }
}

