/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.lingo.internal.manager;

import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.internal.api.lingo.manager.LingoManager;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageManager;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoInput;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoQueryRequest;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoTranslationInput;
import com.atlassian.servicedesk.internal.api.lingo.response.Lingo;
import com.atlassian.servicedesk.internal.api.lingo.response.LingoTranslation;
import com.atlassian.servicedesk.plugins.lingo.internal.analytics.LingoAnalyticsEventHelper;
import com.atlassian.servicedesk.plugins.lingo.internal.dao.LingoQStore;
import com.atlassian.servicedesk.plugins.lingo.internal.manager.LingoPortugueseLocaleCompatibilityManager;
import com.atlassian.servicedesk.plugins.lingo.internal.request.LingoInputImpl;
import com.atlassian.servicedesk.plugins.lingo.internal.response.LingoImpl;
import com.atlassian.servicedesk.plugins.lingo.internal.response.LingoTranslationImpl;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@ParametersAreNonnullByDefault
public class LingoManagerImpl
implements LingoManager {
    private static final Logger LOG = LoggerFactory.getLogger(LingoManagerImpl.class);
    private final LingoQStore lingoQStore;
    private final DatabaseAccessor databaseAccessor;
    private final I18nHelper i18nHelper;
    private final I18nHelper.BeanFactory i18nFactory;
    private final LingoProjectLanguageManager lingoProjectLanguageManager;
    private final LocaleManager localeManager;
    private final LingoAnalyticsEventHelper lingoAnalyticsEventHelper;
    private final LingoPortugueseLocaleCompatibilityManager lingoPortugueseLocaleCompatibilityManager;

    @Autowired
    public LingoManagerImpl(LingoQStore lingoQStore, DatabaseAccessor databaseAccessor, I18nHelper i18nHelper, I18nHelper.BeanFactory i18nFactory, LingoProjectLanguageManager lingoProjectLanguageManager, LocaleManager localeManager, LingoAnalyticsEventHelper lingoAnalyticsEventHelper, LingoPortugueseLocaleCompatibilityManager lingoPortugueseLocaleCompatibilityManager) {
        this.lingoQStore = lingoQStore;
        this.databaseAccessor = databaseAccessor;
        this.i18nHelper = i18nHelper;
        this.i18nFactory = i18nFactory;
        this.lingoProjectLanguageManager = lingoProjectLanguageManager;
        this.localeManager = localeManager;
        this.lingoAnalyticsEventHelper = lingoAnalyticsEventHelper;
        this.lingoPortugueseLocaleCompatibilityManager = lingoPortugueseLocaleCompatibilityManager;
    }

    @NotNull
    public Option<Lingo> retrieveLingo(LingoQueryRequest lingoRequest) {
        Option<Lingo> lingoOpt = this.retrieveLingoInternal(lingoRequest);
        return lingoOpt.map(lingo -> this.applySystemI18nDefaultsIfApplicable((Lingo)lingo, this.retrieveAvailableLocales((Lingo)lingo)));
    }

    public Option<Lingo> retrieveLingo(LingoQueryRequest lingoRequest, Function<Locale, String> defaultValueProvider) {
        Option<Lingo> lingoOpt = this.retrieveLingoInternal(lingoRequest);
        return lingoOpt.map(lingo -> this.applyDefaultForMissingLanguages((Lingo)lingo, defaultValueProvider, this.retrieveAvailableLocales((Lingo)lingo)));
    }

    private Option<Lingo> retrieveLingoInternal(LingoQueryRequest lingoRequest) {
        return ((Option)this.databaseAccessor.run(connection -> this.retrieveLingoByTechnicalId((DatabaseConnection)connection, (Option<Long>)lingoRequest.getTechnicalId()).orElse(() -> this.retrieveLingoByLogicalId((DatabaseConnection)connection, (Option<String>)lingoRequest.getLogicalId(), (Option<Long>)lingoRequest.getProjectId())))).map(lingo -> this.lingoPortugueseLocaleCompatibilityManager.applyTransformation((Lingo)lingo, this.retrieveAvailableLocales((Lingo)lingo))).map(this::filterUnusedProjectLanguages);
    }

    private Lingo filterUnusedProjectLanguages(Lingo lingo) {
        Set<Locale> activeLocales = this.retrieveAvailableLocales(lingo);
        List<LingoTranslation> filteredTranslations = lingo.getTranslations().stream().filter(translation -> activeLocales.contains(translation.getLocale())).collect(Collectors.toList());
        return LingoImpl.withTranslations(lingo, filteredTranslations);
    }

    private Lingo applySystemI18nDefaultsIfApplicable(Lingo lingo, Set<Locale> activeLocales) {
        return (Lingo)lingo.getSystemI18n().fold(() -> lingo, systemI18nKey -> this.applyDefaultForMissingLanguages(lingo, locale -> this.getI18nTranslation((String)systemI18nKey, (Locale)locale), activeLocales));
    }

    private Lingo applyDefaultForMissingLanguages(Lingo lingo, Function<Locale, String> defaultValueProvider, Set<Locale> usedLocales) {
        ImmutableList.Builder updatedTranslationsBuilder = ImmutableList.builder();
        Set existingTranslationLocales = lingo.getTranslations().stream().map(LingoTranslation::getLocale).collect(Collectors.toSet());
        updatedTranslationsBuilder.addAll(this.getSupportedLingoTranslations(lingo, usedLocales));
        Set activeLocales = (Set)lingo.getProjectId().fold(() -> usedLocales, projectId -> this.lingoProjectLanguageManager.retrieveProjectLocales(projectId, false));
        usedLocales.stream().filter(locale -> !existingTranslationLocales.contains(locale)).forEach(locale -> updatedTranslationsBuilder.add((Object)this.createLingoTranslationFromDefaultProvider(defaultValueProvider, (Locale)locale, activeLocales.contains(locale))));
        return LingoImpl.withTranslations(lingo, (Collection<LingoTranslation>)updatedTranslationsBuilder.build());
    }

    private List<LingoTranslation> getSupportedLingoTranslations(Lingo lingo, Set<Locale> locales) {
        return lingo.getTranslations().stream().filter(translation -> locales.contains(translation.getLocale())).collect(Collectors.toList());
    }

    private Set<Locale> retrieveAvailableLocales(Lingo lingo) {
        return (Set)lingo.getProjectId().fold(() -> ((LocaleManager)this.localeManager).getInstalledLocales(), projectId -> this.lingoProjectLanguageManager.retrieveProjectLocales(projectId, true));
    }

    private LingoTranslation createLingoTranslationFromDefaultProvider(Function<Locale, String> defaultValueProvider, Locale locale, boolean activeTranslation) {
        return new LingoTranslationImpl(locale.getLanguage(), locale, () -> (String)defaultValueProvider.apply(locale), activeTranslation, true);
    }

    public Option<Long> storeLingo(LingoInput lingoInput) {
        return this.storeLingoInternal(lingoInput, (Option<Function<Locale, String>>)Option.none());
    }

    public Option<Long> storeLingo(LingoInput lingoInput, Function<Locale, String> defaultValueProvider) {
        return this.storeLingoInternal(lingoInput, (Option<Function<Locale, String>>)Option.some(defaultValueProvider));
    }

    private Option<Long> storeLingoInternal(LingoInput lingoInput, Option<Function<Locale, String>> userDefinedDefaultValueProvider) {
        return (Option)this.databaseAccessor.run(connection -> {
            Option existingLingoOpt = this.retrieveLingoByTechnicalId((DatabaseConnection)connection, (Option<Long>)lingoInput.getTechnicalId()).orElse(() -> this.retrieveLingoByLogicalId((DatabaseConnection)connection, (Option<String>)lingoInput.getLogicalId(), (Option<Long>)lingoInput.getProjectId()));
            Option defaultProvider = (Option)userDefinedDefaultValueProvider.fold(() -> this.createSystemI18nDefaultValueProvider(lingoInput, (Option<Lingo>)existingLingoOpt), Option::some);
            LingoInput defaultFilteredLingoInput = this.discardBlankOrDefaultTranslations(lingoInput, (Option<Function<Locale, String>>)defaultProvider);
            this.lingoAnalyticsEventHelper.fireCustomTranslationsStoredEvent(lingoInput, (Option<Lingo>)existingLingoOpt);
            return (Option)existingLingoOpt.fold(() -> this.lingoQStore.insertLingo((DatabaseConnection)connection, defaultFilteredLingoInput), existingLingo -> this.lingoQStore.updateLingo((DatabaseConnection)connection, existingLingo.getId(), defaultFilteredLingoInput));
        });
    }

    private Option<Function<Locale, String>> createSystemI18nDefaultValueProvider(LingoInput lingoInput, Option<Lingo> existingLingoOpt) {
        Option systemI18nKeyOpt = (Option)existingLingoOpt.fold(() -> ((LingoInput)lingoInput).getSystemI18n(), Lingo::getSystemI18n);
        return systemI18nKeyOpt.map(i18nKey -> locale -> this.getI18nTranslation((String)i18nKey, (Locale)locale));
    }

    private Option<Lingo> retrieveLingoByTechnicalId(DatabaseConnection connection, Option<Long> technicalIdOpt) {
        return technicalIdOpt.flatMap(technicalId -> {
            List<Lingo> lingos = this.lingoQStore.retrieveLanguages(connection, (Long)technicalId, (arg_0, arg_1) -> ((LingoProjectLanguageManager)this.lingoProjectLanguageManager).isEnabled(arg_0, arg_1));
            return this.resultListToOption(lingos, () -> this.i18nHelper.getText("sd.lingo.request.result.not.unique.for.technical.id", technicalId));
        });
    }

    private Option<Lingo> retrieveLingoByLogicalId(DatabaseConnection connection, Option<String> logicalIdOpt, Option<Long> projectId) {
        return logicalIdOpt.flatMap(logicalId -> {
            List<Lingo> lingos = this.lingoQStore.retrieveLanguages(connection, projectId, (String)logicalId, (arg_0, arg_1) -> ((LingoProjectLanguageManager)this.lingoProjectLanguageManager).isEnabled(arg_0, arg_1));
            return this.resultListToOption(lingos, () -> this.i18nHelper.getText("sd.lingo.request.result.not.unique.for.logical.id", logicalId));
        });
    }

    private Option<Lingo> resultListToOption(List<Lingo> lingos, Supplier<String> errorForNonUniqueResult) {
        if (lingos.isEmpty()) {
            return Option.none();
        }
        if (lingos.size() > 1) {
            LOG.error(errorForNonUniqueResult.get());
        }
        return Option.some((Object)lingos.get(0));
    }

    private LingoInput discardBlankOrDefaultTranslations(LingoInput lingoInput, Option<Function<Locale, String>> defaultValueProviderOpt) {
        Predicate<LingoTranslationInput> isNotBlankOrDefault = this.createIsNotBlankOrDefaultTranslationPredicate(defaultValueProviderOpt);
        List<LingoTranslationInput> translationsWithoutBlanksOrDefaults = lingoInput.getTranslations().stream().filter(isNotBlankOrDefault).collect(Collectors.toList());
        return LingoInputImpl.withTranslations(lingoInput, translationsWithoutBlanksOrDefaults);
    }

    private Predicate<LingoTranslationInput> createIsNotBlankOrDefaultTranslationPredicate(Option<Function<Locale, String>> defaultValueProviderOpt) {
        Predicate<LingoTranslationInput> isBlankOrDefault = input -> {
            String content = input.getContent();
            if (StringUtils.isBlank((String)content)) {
                return true;
            }
            return (Boolean)defaultValueProviderOpt.fold(() -> false, defaultProvider -> Objects.equals(defaultProvider.apply(input.getLocale()), content));
        };
        return isBlankOrDefault.negate();
    }

    private String getI18nTranslation(String i18nKey, Locale locale) {
        return this.i18nFactory.getInstance(locale).getText(i18nKey);
    }
}

