/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.lingo.internal.dao;

import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoInput;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoTranslationInput;
import com.atlassian.servicedesk.internal.api.lingo.response.Lingo;
import com.atlassian.servicedesk.internal.api.lingo.response.LingoTranslation;
import com.atlassian.servicedesk.plugins.lingo.internal.dao.schema.querydsl.mapping.Tables;
import com.atlassian.servicedesk.plugins.lingo.internal.response.LingoBuilder;
import com.atlassian.servicedesk.plugins.lingo.internal.response.LingoTranslationImpl;
import com.google.common.annotations.VisibleForTesting;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import org.springframework.stereotype.Component;

@Component
public class LingoQStore {
    public Option<Long> insertLingo(DatabaseConnection connection, LingoInput lingo) {
        long createdEpoch = new Date().getTime();
        Long lingoId = this.insertLingoInternal(connection, lingo, createdEpoch);
        Long revisionId = this.insertLingoRevision(connection, lingoId, createdEpoch);
        this.insertLingoTranslations(connection, revisionId, lingo.getTranslations(), createdEpoch);
        return Option.option((Object)lingoId);
    }

    public Option<Long> updateLingo(DatabaseConnection connection, Long id, LingoInput lingo) {
        long createdEpoch = new Date().getTime();
        Long revisionId = this.insertLingoRevision(connection, id, createdEpoch);
        this.insertLingoTranslations(connection, revisionId, lingo.getTranslations(), createdEpoch);
        return Option.option((Object)id);
    }

    private Long insertLingoInternal(DatabaseConnection connection, LingoInput lingo, long createdEpoch) {
        SQLInsertClause sqlClause = connection.insert((RelationalPath)Tables.LINGO).set(Tables.LINGO.CREATED_TIMESTAMP, (Object)createdEpoch);
        lingo.getCategory().forEach(category -> sqlClause.set((Path)Tables.LINGO.CATEGORY, category));
        lingo.getLogicalId().forEach(logicalId -> sqlClause.set((Path)Tables.LINGO.LOGICAL_ID, logicalId));
        lingo.getSystemI18n().forEach(i18n -> sqlClause.set((Path)Tables.LINGO.SYSTEM_I18N, i18n));
        lingo.getProjectId().forEach(projectId -> sqlClause.set(Tables.LINGO.PROJECT_ID, projectId));
        return (Long)sqlClause.executeWithKey(Tables.LINGO.ID);
    }

    private Long insertLingoRevision(DatabaseConnection connection, Long lingoId, long createdEpoch) {
        return (Long)connection.insert((RelationalPath)Tables.LINGO_REVISION).set(Tables.LINGO_REVISION.LINGO_ID, (Object)lingoId).set(Tables.LINGO_REVISION.CREATED_TIMESTAMP, (Object)createdEpoch).executeWithKey(Tables.LINGO_REVISION.ID);
    }

    private void insertLingoTranslations(DatabaseConnection connection, Long revisionId, List<LingoTranslationInput> translations, long createdEpoch) {
        if (!translations.isEmpty()) {
            SQLInsertClause clause = connection.insert((RelationalPath)Tables.LINGO_TRANSLATION);
            for (LingoTranslationInput input : translations) {
                clause.set((Path)Tables.LINGO_TRANSLATION.LOCALE, (Object)input.getLocale().toLanguageTag()).set(Tables.LINGO_TRANSLATION.LINGO_REVISION_ID, (Object)revisionId).set(Tables.LINGO_TRANSLATION.CREATED_TIMESTAMP, (Object)createdEpoch).set((Path)Tables.LINGO_TRANSLATION.LANGUAGE, (Object)input.getLocale().getLanguage()).set((Path)Tables.LINGO_TRANSLATION.CONTENT, (Object)input.getContent()).addBatch();
            }
            clause.execute();
        }
    }

    public List<Lingo> retrieveLanguages(DatabaseConnection connection, Long technicalId, BiFunction<Locale, Option<Long>, Boolean> isEnabledFunction) {
        return this.internalRetrieveLanguages(connection, Tables.LINGO.ID.eq((Object)technicalId), isEnabledFunction);
    }

    public List<Lingo> retrieveLanguages(DatabaseConnection connection, Option<Long> projectIdOption, String logicalId, BiFunction<Locale, Option<Long>, Boolean> isEnabledFunction) {
        return this.internalRetrieveLanguages(connection, this.retrieveLogicalIdCondition(projectIdOption, logicalId), isEnabledFunction);
    }

    private BooleanExpression retrieveLogicalIdCondition(Option<Long> projectIdOption, String logicalId) {
        return (BooleanExpression)projectIdOption.fold(() -> Tables.LINGO.LOGICAL_ID.eq((Object)logicalId).and((Predicate)Tables.LINGO.PROJECT_ID.isNull()), projectId -> Tables.LINGO.LOGICAL_ID.eq((Object)logicalId).and((Predicate)Tables.LINGO.PROJECT_ID.eq(projectId)));
    }

    private List<Lingo> internalRetrieveLanguages(DatabaseConnection connection, BooleanExpression idComparison, BiFunction<Locale, Option<Long>, Boolean> isEnabledFunction) {
        List result = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(new Expression[]{Tables.LINGO.ID, Tables.LINGO.CATEGORY, Tables.LINGO.LOGICAL_ID, Tables.LINGO.SYSTEM_I18N, Tables.LINGO.PROJECT_ID, Tables.LINGO_TRANSLATION.LANGUAGE, Tables.LINGO_TRANSLATION.LOCALE, Tables.LINGO_TRANSLATION.CONTENT}).from((Expression)Tables.LINGO)).innerJoin((EntityPath)Tables.LINGO_REVISION)).on((Predicate)Tables.LINGO.ID.eq(Tables.LINGO_REVISION.LINGO_ID))).leftJoin((EntityPath)Tables.LINGO_TRANSLATION)).on((Predicate)Tables.LINGO_REVISION.ID.eq(Tables.LINGO_TRANSLATION.LINGO_REVISION_ID))).where((Predicate)idComparison.and((Predicate)Tables.LINGO_REVISION.ID.eq((Expression)((SQLQuery)SQLExpressions.select((Expression)SQLExpressions.max(Tables.LINGO_REVISION.ID)).from((Expression)Tables.LINGO_REVISION)).where((Predicate)Tables.LINGO_REVISION.LINGO_ID.eq(Tables.LINGO.ID)))))).orderBy(Tables.LINGO.ID.asc())).fetch();
        return this.transform(result, isEnabledFunction);
    }

    @VisibleForTesting
    List<Lingo> transform(List<Tuple> result, BiFunction<Locale, Option<Long>, Boolean> isEnabledFunction) {
        ArrayList<Lingo> lingos = new ArrayList<Lingo>();
        LingoBuilder builder = null;
        for (Tuple tuple : result) {
            Long id = (Long)tuple.get(Tables.LINGO.ID);
            if (this.isNewLingo(builder, id)) {
                if (builder != null) {
                    lingos.add(builder.build());
                }
                builder = LingoBuilder.newBuilder().id(id).category((String)tuple.get((Expression)Tables.LINGO.CATEGORY)).logicalId((String)tuple.get((Expression)Tables.LINGO.LOGICAL_ID)).projectId((Long)tuple.get(Tables.LINGO.PROJECT_ID)).systemI18n((String)tuple.get((Expression)Tables.LINGO.SYSTEM_I18N));
            }
            if (tuple.get((Expression)Tables.LINGO_TRANSLATION.LOCALE) == null) continue;
            builder.addTranslation(this.createTranslation(tuple, isEnabledFunction));
        }
        if (builder != null) {
            lingos.add(builder.build());
        }
        return Collections.unmodifiableList(lingos);
    }

    private boolean isNewLingo(LingoBuilder builder, Long id) {
        return builder == null || !builder.isSameId(id);
    }

    private LingoTranslation createTranslation(Tuple tuple, BiFunction<Locale, Option<Long>, Boolean> isEnabledFunction) {
        Option projectId = Option.option((Object)tuple.get(Tables.LINGO.PROJECT_ID));
        String language = (String)tuple.get((Expression)Tables.LINGO_TRANSLATION.LANGUAGE);
        Locale locale = Locale.forLanguageTag((String)tuple.get((Expression)Tables.LINGO_TRANSLATION.LOCALE));
        String content = (String)tuple.get((Expression)Tables.LINGO_TRANSLATION.CONTENT);
        return new LingoTranslationImpl(language, locale, content, (boolean)isEnabledFunction.apply(locale, (Option<Long>)projectId), false);
    }
}

