/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.lingo.internal.dao;

import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguage;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageInput;
import com.atlassian.servicedesk.plugins.lingo.internal.dao.schema.querydsl.mapping.Tables;
import com.atlassian.servicedesk.plugins.lingo.internal.project.LingoProjectLanguageImpl;
import com.google.common.collect.ImmutableSet;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LingoProjectLanguageQStore {
    private static final Logger LOG = LoggerFactory.getLogger(LingoProjectLanguageQStore.class);

    public Long insertProjectLanguageConfig(DatabaseConnection connection, String authorKey, LingoProjectLanguageInput input) {
        long createdEpoch = new Date().getTime();
        Long id = this.insertProjectLanguageConfig(connection, input.getProjectId(), createdEpoch);
        Long revisionId = this.insertProjectLanguageConfigRevision(connection, id, authorKey, createdEpoch, input.getDefaultLanguage());
        this.insertProjectLanguages(connection, revisionId, input.getLanguages());
        return id;
    }

    public Long updateProjectLanguageConfig(DatabaseConnection connection, Long id, String authorKey, LingoProjectLanguageInput input) {
        long createdEpoch = new Date().getTime();
        Long revisionId = this.insertProjectLanguageConfigRevision(connection, id, authorKey, createdEpoch, input.getDefaultLanguage());
        this.insertProjectLanguages(connection, revisionId, input.getLanguages());
        return id;
    }

    private Long insertProjectLanguageConfig(DatabaseConnection connection, Long projectId, long createdEpoch) {
        return (Long)connection.insert((RelationalPath)Tables.PROJECT_LANG_CONFIG).set(Tables.PROJECT_LANG_CONFIG.PROJECT_ID, (Object)projectId).set(Tables.PROJECT_LANG_CONFIG.CREATED_TIMESTAMP, (Object)createdEpoch).executeWithKey(Tables.PROJECT_LANG_CONFIG.ID);
    }

    private Long insertProjectLanguageConfigRevision(DatabaseConnection connection, Long configId, String authorKey, long createdEpoch, Locale defaultLanguage) {
        String defaultLanguageTag = defaultLanguage.toLanguageTag();
        return (Long)connection.insert((RelationalPath)Tables.PROJECT_LANG_REVISION).set(Tables.PROJECT_LANG_REVISION.PROJECT_LANG_CONFIG_ID, (Object)configId).set(Tables.PROJECT_LANG_REVISION.CREATED_TIMESTAMP, (Object)createdEpoch).set((Path)Tables.PROJECT_LANG_REVISION.AUTHOR_USER_KEY, (Object)authorKey).set((Path)Tables.PROJECT_LANG_REVISION.DEFAULT_LANGUAGE, (Object)defaultLanguageTag).executeWithKey(Tables.PROJECT_LANG_REVISION.ID);
    }

    private void insertProjectLanguages(DatabaseConnection connection, Long revisionId, Set<LingoProjectLanguage> languages) {
        if (!languages.isEmpty()) {
            SQLInsertClause clause = connection.insert((RelationalPath)Tables.PROJECT_LANGUAGE);
            for (LingoProjectLanguage input : languages) {
                clause.set((Path)Tables.PROJECT_LANGUAGE.LOCALE, (Object)input.getLocale().toLanguageTag()).set((Path)Tables.PROJECT_LANGUAGE.ACTIVE, (Object)input.isActive()).set(Tables.PROJECT_LANGUAGE.PROJECT_LANG_REV_ID, (Object)revisionId).addBatch();
            }
            clause.execute();
        }
    }

    public Option<Long> retrieveProjectLanguageConfigId(DatabaseConnection connection, long projectId) {
        return Option.option((Object)((SQLQuery)((SQLQuery)connection.select(Tables.PROJECT_LANG_CONFIG.ID).from((Expression)Tables.PROJECT_LANG_CONFIG)).where((Predicate)Tables.PROJECT_LANG_CONFIG.PROJECT_ID.eq((Object)projectId))).fetchOne());
    }

    public Option<Locale> retrieveProjectDefaultLanguage(DatabaseConnection connection, long projectId) {
        String defaultLanguage = (String)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select((Expression)Tables.PROJECT_LANG_REVISION.DEFAULT_LANGUAGE).from((Expression)Tables.PROJECT_LANG_CONFIG)).innerJoin((EntityPath)Tables.PROJECT_LANG_REVISION)).on((Predicate)Tables.PROJECT_LANG_CONFIG.ID.eq(Tables.PROJECT_LANG_REVISION.PROJECT_LANG_CONFIG_ID))).where((Predicate)Tables.PROJECT_LANG_CONFIG.PROJECT_ID.eq((Object)projectId).and(this.maxProjectLangRevisionPredicate()))).fetchOne();
        if (StringUtils.isBlank((String)defaultLanguage)) {
            return Option.none();
        }
        return Option.some((Object)Locale.forLanguageTag(defaultLanguage));
    }

    public Option<Set<LingoProjectLanguage>> retrieveProjectLanguages(DatabaseConnection connection, long projectId) {
        List projectLanguageTuples = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(new Expression[]{Tables.PROJECT_LANGUAGE.LOCALE, Tables.PROJECT_LANGUAGE.ACTIVE}).from((Expression)Tables.PROJECT_LANG_CONFIG)).innerJoin((EntityPath)Tables.PROJECT_LANG_REVISION)).on((Predicate)Tables.PROJECT_LANG_CONFIG.ID.eq(Tables.PROJECT_LANG_REVISION.PROJECT_LANG_CONFIG_ID))).innerJoin((EntityPath)Tables.PROJECT_LANGUAGE)).on((Predicate)Tables.PROJECT_LANG_REVISION.ID.eq(Tables.PROJECT_LANGUAGE.PROJECT_LANG_REV_ID))).where((Predicate)Tables.PROJECT_LANG_CONFIG.PROJECT_ID.eq((Object)projectId).and(this.maxProjectLangRevisionPredicate()))).fetch();
        Set<LingoProjectLanguage> projectLanguages = this.transform(projectLanguageTuples);
        if (projectLanguages == null || projectLanguages.isEmpty()) {
            return Option.none();
        }
        return Option.some(projectLanguages);
    }

    private Predicate maxProjectLangRevisionPredicate() {
        return Tables.PROJECT_LANG_REVISION.ID.eq((Expression)((SQLQuery)SQLExpressions.select((Expression)SQLExpressions.max(Tables.PROJECT_LANG_REVISION.ID)).from((Expression)Tables.PROJECT_LANG_REVISION)).where((Predicate)Tables.PROJECT_LANG_REVISION.PROJECT_LANG_CONFIG_ID.eq(Tables.PROJECT_LANG_CONFIG.ID)));
    }

    private Set<LingoProjectLanguage> transform(List<Tuple> projectLanguageTuples) {
        if (projectLanguageTuples == null || projectLanguageTuples.isEmpty()) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        projectLanguageTuples.forEach(languageTuple -> {
            String localeAsString = (String)languageTuple.get((Expression)Tables.PROJECT_LANGUAGE.LOCALE);
            if (localeAsString == null) {
                LOG.error("Unexpected project language stored with null locale. Will ignore it.");
            } else {
                Locale locale = Locale.forLanguageTag(localeAsString);
                boolean isActive = BooleanUtils.toBoolean((Boolean)((Boolean)languageTuple.get((Expression)Tables.PROJECT_LANGUAGE.ACTIVE)));
                result.add((Object)new LingoProjectLanguageImpl(locale, isActive));
            }
        });
        return result.build();
    }
}

