/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.lingo.internal.bootstrap.info;

import com.atlassian.servicedesk.plugins.lingo.internal.bootstrap.info.LingoPluginInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.springframework.stereotype.Component;

@Component
public class LingoPluginInfoImpl
implements LingoPluginInfo {
    private final String version;
    private final DateTime buildDate;
    private final String changeSet;

    public LingoPluginInfoImpl() {
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("/buildprops/BuildProperties.properties");
        if (resourceAsStream == null) {
            throw new IllegalStateException("Unable to find 'BuildProperties.properties' - we have a serious build issue");
        }
        Properties properties = new Properties();
        try {
            properties.load(resourceAsStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load 'BuildProperties.properties' - we have a serious build issue");
        }
        this.version = this.getRequiredProp(properties, "sd.lingo.version");
        this.buildDate = new DateTime((Object)this.getRequiredProp(properties, "sd.lingo.build.date"));
        this.changeSet = this.getOptionalProp(properties, "sd.lingo.changeset", "DevVersion");
    }

    private String getRequiredProp(Properties properties, String key) {
        return this.getBuildProp(properties, key, true);
    }

    private String getOptionalProp(Properties properties, String key, String defaultValue) {
        String prop = this.getBuildProp(properties, key, false);
        return this.isNull(prop) ? defaultValue : prop;
    }

    private boolean isNull(String prop) {
        return StringUtils.isBlank((String)prop) || "null".equals(prop);
    }

    private String getBuildProp(Properties properties, String key, boolean required) {
        String prop = properties.getProperty(key);
        if (prop == null && required) {
            throw new IllegalStateException("Failed to load a BuildProperty: '" + key + "' - we have a serious build issue");
        }
        return prop;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public DateTime getBuildDate() {
        return this.buildDate;
    }

    @Override
    public String getChangeSet() {
        return this.changeSet;
    }
}

