/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.lingo.internal.analytics;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoInput;
import com.atlassian.servicedesk.internal.api.lingo.response.Lingo;
import com.atlassian.servicedesk.plugins.lingo.internal.analytics.LingoAnalyticsEvent;
import io.atlassian.fugue.Option;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LingoAnalyticsEventHelper {
    private static final String CUSTOM_LANGUAGES_STORED_PREFIX = "servicedesk.lingo.custom.translations.stored";
    private final EventPublisher eventPublisher;

    @Autowired
    public LingoAnalyticsEventHelper(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void fireCustomTranslationsStoredEvent(LingoInput lingoInput, Option<Lingo> existingLingo) {
        LingoAnalyticsEvent event = this.retrieveCustomTranslationsStoreEvent(lingoInput, existingLingo);
        this.eventPublisher.publish((Object)event);
    }

    private LingoAnalyticsEvent retrieveCustomTranslationsStoreEvent(LingoInput lingoInput, Option<Lingo> existingLingo) {
        String eventName = this.retrieveEventName(lingoInput, existingLingo);
        Long projectId = this.retrieveProjectId(lingoInput, existingLingo);
        return new LingoAnalyticsEvent(eventName, projectId);
    }

    private Long retrieveProjectId(LingoInput lingoInput, Option<Lingo> existingLingo) {
        return (Long)((Option)existingLingo.fold(() -> ((LingoInput)lingoInput).getProjectId(), Lingo::getProjectId)).getOrNull();
    }

    private String retrieveEventName(LingoInput lingoInput, Option<Lingo> existingLingo) {
        String category = this.retrieveCategory(lingoInput, existingLingo);
        String numberOfTranslations = this.retrieveNumberOfTranslations(lingoInput);
        return CUSTOM_LANGUAGES_STORED_PREFIX + category + numberOfTranslations;
    }

    private String retrieveNumberOfTranslations(LingoInput lingoInput) {
        int numberOfCustomTranslations = lingoInput.getTranslations().size();
        if (numberOfCustomTranslations > 10) {
            return ".more";
        }
        return "." + numberOfCustomTranslations;
    }

    private String retrieveCategory(LingoInput lingoInput, Option<Lingo> existingLingo) {
        String category = (String)((Option)existingLingo.fold(() -> ((LingoInput)lingoInput).getCategory(), Lingo::getCategory)).getOrElse((Object)"");
        if (StringUtils.isBlank((String)category)) {
            return "";
        }
        return "." + category;
    }
}

