/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.kb.internal.webpanel;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.portal.PortalService;
import com.atlassian.servicedesk.api.request.ServiceDeskCustomerRequestService;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseService;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class KBWebPanelHelper {
    private final I18nHelper i18nHelper;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final ServiceDeskService serviceDeskService;
    private final ConfluenceKnowledgeBaseService kbService;
    private final PortalService portalService;
    private final ServiceDeskCustomerRequestService sdCustomerRequestService;

    @Autowired
    public KBWebPanelHelper(I18nHelper i18nHelper, ServiceDeskPermissionService serviceDeskPermissionService, ServiceDeskService serviceDeskService, ConfluenceKnowledgeBaseService kbService, PortalService portalService, ServiceDeskCustomerRequestService sdCustomerRequestService) {
        this.i18nHelper = i18nHelper;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.serviceDeskService = serviceDeskService;
        this.kbService = kbService;
        this.portalService = portalService;
        this.sdCustomerRequestService = sdCustomerRequestService;
    }

    public io.atlassian.fugue.Either<String, Map<String, Object>> getKBPanelParams(Map<String, Object> context) {
        return Steps.begin((io.atlassian.fugue.Either)io.atlassian.fugue.Option.option((Object)((Issue)context.get("issue"))).toRight(() -> "Failed to retrieve issue")).then(issue -> io.atlassian.fugue.Option.option((Object)issue.getProjectObject()).toRight(() -> "Failed to retrieve project")).then((issue, project) -> io.atlassian.fugue.Option.option((Object)((ApplicationUser)context.get("user"))).toRight(() -> "Failed to retrieve user")).then((issue, project, user) -> this.getPortalId((ApplicationUser)user, (Project)project).toRight(() -> "Failed to retrieve portal")).yield((issue, project, user, portalId) -> {
            ImmutableMap.Builder paramBuilder = ImmutableMap.builder().put((Object)"issueKey", (Object)issue.getKey()).put((Object)"issueId", (Object)issue.getId()).put((Object)"projectKey", (Object)project.getKey()).put((Object)"isProjectAdmin", (Object)this.isAdminAgent((ApplicationUser)user, (Project)project)).put((Object)"portalId", portalId).put((Object)"isSDRequest", (Object)this.sdCustomerRequestService.getRequestForKey(user, issue.getKey()).isRight());
            io.atlassian.fugue.Option kbLinkOpt = this.kbService.getKBLink(user, project).toOption();
            if (kbLinkOpt.isDefined()) {
                ConfluenceKnowledgeBaseLink kbLink = (ConfluenceKnowledgeBaseLink)kbLinkOpt.get();
                paramBuilder.put((Object)"appLinkUrl", (Object)kbLink.getApplicationUrl());
                paramBuilder.put((Object)"appLinkId", (Object)kbLink.getApplicationId());
            } else {
                paramBuilder.put((Object)"appLinkUrl", (Object)"");
                paramBuilder.put((Object)"appLinkId", (Object)"");
            }
            return paramBuilder.build();
        });
    }

    private boolean isAdminAgent(ApplicationUser user, Project project) {
        return (Boolean)Steps.begin((Either)this.serviceDeskService.getServiceDeskForProject(user, project)).then(serviceDesk -> this.serviceDeskPermissionService.isAdminAgent(user, serviceDesk)).yield((serviceDesk, isProjectAdmin) -> isProjectAdmin).getOrElse((Object)false);
    }

    private io.atlassian.fugue.Option<Integer> getPortalId(ApplicationUser user, Project project) {
        return StepsConverters.newerOption((Option)this.portalService.getPortalForProject(user, project).right().map(Portal::getId).toOption());
    }
}

