/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.kb.internal.search;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.fugue.Either;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.applink.ApplicationLinkErrors;
import com.atlassian.servicedesk.internal.api.applink.BaseAppLinkResponseHandler;
import com.atlassian.servicedesk.internal.api.feature.applink.ServiceDeskAppLinkService;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.plugins.kb.internal.search.KbArticleSearchQuery;
import com.atlassian.servicedesk.plugins.kb.internal.search.KbArticleSearchQueryImpl;
import com.atlassian.servicedesk.plugins.kb.internal.search.SearchResponseHandler;
import com.atlassian.servicedesk.plugins.kb.internal.search.SearchResults;
import com.atlassian.servicedesk.plugins.kb.internal.search.SearchService;
import io.atlassian.fugue.Option;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class SearchServiceImpl
implements SearchService {
    private final ApplicationLinkService applicationLinkService;
    private final ApplicationLinkErrors applicationLinkErrors;
    private final ErrorResultHelper errorResultHelper;
    private final ApplicationProperties applicationProperties;
    private final ServiceDeskAppLinkService serviceDeskAppLinkService;
    private final UserFactory userFactory;
    private static final Logger logger = LoggerFactory.getLogger(SearchServiceImpl.class);
    private static final String SEARCH_URL_BASE_WITH_VIEW_PERMISSION_CHECK = "/rest/knowledge-base/1.0/search/%s?type=page";
    private static final String OLD_SEARCH_URL_BASE = "/rest/knowledge-base/1.0/search?type=page&where=%s";

    @Autowired
    public SearchServiceImpl(ApplicationLinkService applicationLinkService, ApplicationLinkErrors applicationLinkErrors, ErrorResultHelper errorResultHelper, ApplicationProperties applicationProperties, ServiceDeskAppLinkService serviceDeskAppLinkService, UserFactory userFactory) {
        this.applicationLinkService = applicationLinkService;
        this.applicationLinkErrors = applicationLinkErrors;
        this.errorResultHelper = errorResultHelper;
        this.applicationProperties = applicationProperties;
        this.serviceDeskAppLinkService = serviceDeskAppLinkService;
        this.userFactory = userFactory;
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<AnError, SearchResults> performSearch(ApplicationUser user, KbArticleSearchQuery kbArticleSearchQuery, Boolean useViewPermissionSearch, ConfluenceKnowledgeBaseLink kbLink) {
        return Steps.begin(this.buildSearchRequestUrl(useViewPermissionSearch, kbLink.getSpaceKey(), kbArticleSearchQuery)).then(searchUrl -> this.submitRequest(user, kbArticleSearchQuery.project(), kbLink.getApplicationId(), (String)searchUrl)).yield((searchUrl, searchResults) -> searchResults);
    }

    @Override
    public KbArticleSearchQuery.Builder newQueryBuilder(Project project) {
        return KbArticleSearchQueryImpl.builder(project);
    }

    private io.atlassian.fugue.Either<AnError, String> buildSearchRequestUrl(Boolean useViewPermissionSearch, String kbSpaceKey, KbArticleSearchQuery kbArticleSearchQuery) {
        String baseUrl = useViewPermissionSearch != false ? SEARCH_URL_BASE_WITH_VIEW_PERMISSION_CHECK : OLD_SEARCH_URL_BASE;
        Option query = Option.some((Object)kbArticleSearchQuery.query());
        StringBuilder urlSb = new StringBuilder(String.format(baseUrl, kbSpaceKey));
        return Steps.begin(this.appendQueryParameter(urlSb, "queryString", (Option<String>)query)).then(u -> this.appendQueryParameter(urlSb, "permissionCheckedUser", (Option<String>)kbArticleSearchQuery.permissionCheckedUser().map(ApplicationUser::getUsername))).then((u, u2) -> kbArticleSearchQuery.labels().stream().map(label -> this.appendQueryParameter(urlSb, "labels", (Option<String>)Option.some((Object)label))).filter(io.atlassian.fugue.Either::isLeft).findFirst().orElseGet(() -> io.atlassian.fugue.Either.right((Object)Unit.UNIT))).then((u, u2, u3) -> this.appendQueryParameter(urlSb, "highlight", (Option<String>)Option.some((Object)Boolean.toString(kbArticleSearchQuery.getHighlight())))).yield((u, u2, u3, u4) -> urlSb.toString());
    }

    private io.atlassian.fugue.Either<AnError, Unit> appendQueryParameter(StringBuilder urlSb, String queryParamKey, Option<String> queryParamValueOpt) {
        try {
            if (!queryParamValueOpt.isEmpty()) {
                urlSb.append(String.format("&%s=%s", queryParamKey, URLEncoder.encode((String)queryParamValueOpt.get(), this.applicationProperties.getEncoding())));
            }
            return io.atlassian.fugue.Either.right((Object)Unit.UNIT);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Error encoding query parameters for Knowledge base request url", (Throwable)e);
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(412, "sd.knowledge.base.applink.url.parameter.encoding.error", new Object[0]));
        }
    }

    private io.atlassian.fugue.Either<AnError, SearchResults> submitRequest(ApplicationUser user, Project project, String appLinkApplicationId, String url) {
        return Steps.begin(this.getApplicationLink(new ApplicationId(appLinkApplicationId))).then(appLink -> StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then((appLink, checkedUser) -> this.serviceDeskAppLinkService.makeGetRequest(checkedUser, project, appLinkApplicationId, url, (BaseAppLinkResponseHandler)new SearchResponseHandler(this.errorResultHelper, (ApplicationLink)appLink, this.applicationLinkErrors))).yield((appLink, checkedUser, searchResults) -> searchResults);
    }

    private io.atlassian.fugue.Either<AnError, ApplicationLink> getApplicationLink(ApplicationId appId) {
        try {
            return Steps.begin((io.atlassian.fugue.Either)Option.option((Object)this.applicationLinkService.getApplicationLink(appId)).toRight(() -> this.errorResultHelper.anError(501, "sd.knowledge.base.applink.invalid.app.id", new Object[0]))).yield(appLink -> appLink);
        }
        catch (TypeNotInstalledException e) {
            logger.error("Application type for Application Link with id " + appId + " not installed", (Throwable)e);
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(501, "sd.knowledge.base.applink.application.type.not.installed", new Object[0]));
        }
    }
}

