/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.kb.internal.search;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.servicedesk.internal.api.applink.ApplicationLinkErrors;
import com.atlassian.servicedesk.internal.api.applink.BaseAppLinkResponseHandler;
import com.atlassian.servicedesk.plugins.kb.internal.search.SearchResults;
import io.atlassian.fugue.Option;
import java.net.URI;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SearchResponseHandler
extends BaseAppLinkResponseHandler<SearchResults> {
    private final ApplicationLink applicationLink;
    private static final Logger logger = LoggerFactory.getLogger(SearchResponseHandler.class);

    SearchResponseHandler(ErrorResultHelper errorResultHelper, ApplicationLink applicationLink, ApplicationLinkErrors applicationLinkErrors) {
        super(applicationLinkErrors, errorResultHelper);
        this.applicationLink = applicationLink;
    }

    public io.atlassian.fugue.Either<AnError, SearchResults> onResponseException(ResponseException responseException) {
        return StepsConverters.newerEither((Either)this.errorResultHelper.error(503, "sd.knowledge.base.applink.request.failure", new Object[0]));
    }

    public io.atlassian.fugue.Either<AnError, SearchResults> onCredentialError(String responseBody) {
        logger.warn("Credentials rejected by Knowledge base server");
        return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.unauthorized401("sd.knowledge.base.applink.credentials.rejected", new Object[0]).build());
    }

    public io.atlassian.fugue.Either<AnError, SearchResults> onError(String responseBody, int statusCode) {
        if (statusCode == Response.Status.FORBIDDEN.getStatusCode()) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.forbidden403("sd.knowledge.base.applink.forbidden", new Object[0]).build());
        }
        if (statusCode == Response.Status.NOT_FOUND.getStatusCode()) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.builder("sd.knowledge.base.applink.not.found", new Object[0]).httpStatusCode(500).build());
        }
        if (statusCode == Response.Status.BAD_REQUEST.getStatusCode()) {
            log.debug("The knowledge base server rejected the request with the following message: %s", (Object)responseBody);
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.internalServiceError500("sd.knowledge.base.applink.bad.request", new Object[0]).build());
        }
        return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.builder("sd.knowledge.base.applink.error.response", new Object[0]).httpStatusCode(500).build());
    }

    public io.atlassian.fugue.Either<AnError, SearchResults> onSuccess(String responseBody) {
        String baseUrl = (String)Option.option((Object)this.applicationLink.getDisplayUrl()).fold(() -> "", URI::toString);
        return io.atlassian.fugue.Either.right((Object)new SearchResults(baseUrl, responseBody));
    }
}

