/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.kb.internal.search;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.plugins.kb.internal.search.KbArticleSearchQuery;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class KbArticleSearchQueryImpl
implements KbArticleSearchQuery {
    private final Option<ApplicationUser> permissionCheckedUser;
    private final Project project;
    private final String query;
    private final List<String> labels;
    private final Boolean highlight;

    private KbArticleSearchQueryImpl(Option<ApplicationUser> permissionCheckedUser, Project project, String query, List<String> labels, Boolean highlight) {
        this.permissionCheckedUser = permissionCheckedUser;
        this.project = project;
        this.query = query;
        this.labels = labels;
        this.highlight = highlight;
    }

    @Override
    public Option<ApplicationUser> permissionCheckedUser() {
        return this.permissionCheckedUser;
    }

    @Override
    public Project project() {
        return this.project;
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    public List<String> labels() {
        return this.labels;
    }

    @Override
    public Boolean getHighlight() {
        return this.highlight;
    }

    public static KbArticleSearchQuery.Builder builder(Project project) {
        return new BuilderImpl(project);
    }

    @ParametersAreNonnullByDefault
    public static class BuilderImpl
    implements KbArticleSearchQuery.Builder {
        private Option<ApplicationUser> permissionCheckedUser = Option.none();
        private Project project;
        private String query = "";
        private List<String> labels = Lists.newArrayList();
        private boolean highlight = false;

        private BuilderImpl(Project project) {
            this.project = project;
        }

        @Override
        public KbArticleSearchQuery.Builder permissionCheckedUser(Option<ApplicationUser> permissionCheckUser) {
            this.permissionCheckedUser = permissionCheckUser;
            return this;
        }

        @Override
        public KbArticleSearchQuery.Builder project(Project project) {
            this.project = project;
            return this;
        }

        @Override
        public KbArticleSearchQuery.Builder query(String query) {
            this.query = query;
            return this;
        }

        @Override
        public KbArticleSearchQuery.Builder labels(Iterable<String> labels) {
            this.labels = Lists.newArrayList(labels);
            return this;
        }

        @Override
        public KbArticleSearchQuery.Builder highlight(Boolean highlight) {
            this.highlight = highlight;
            return this;
        }

        @Override
        public KbArticleSearchQuery build() {
            return new KbArticleSearchQueryImpl(this.permissionCheckedUser, this.project, this.query, this.labels, this.highlight);
        }
    }
}

