/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.kb.internal.rest;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.plugins.kb.internal.article.ArticleService;
import com.atlassian.servicedesk.plugins.kb.internal.model.Article;
import com.atlassian.servicedesk.plugins.kb.internal.model.ArticleSearchResults;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/articles")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ArticleResource {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final IssueManager issueManager;
    private final ArticleService articleService;
    private final ErrorResultHelper errorResultHelper;
    private final ProjectManager projectManager;
    private final RestResponseHelper restResponseHelper;

    public ArticleResource(JiraAuthenticationContext jiraAuthenticationContext, IssueManager issueManager, ArticleService articleService, ErrorResultHelper errorResultHelper, ProjectManager projectManager, RestResponseHelper restResponseHelper) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.issueManager = issueManager;
        this.articleService = articleService;
        this.errorResultHelper = errorResultHelper;
        this.projectManager = projectManager;
        this.restResponseHelper = restResponseHelper;
    }

    @Path(value="/search")
    @GET
    public Response searchArticles(@QueryParam(value="query") String query, @QueryParam(value="project") String projectKey, @QueryParam(value="label") List<String> labels) {
        Project project = this.projectManager.getProjectObjByKey(projectKey);
        return (Response)Steps.begin(this.getLoggedinUser()).then(user -> Option.option((Object)project).toRight(() -> this.errorResultHelper.anError(412, "sd.knowledge.base.find.related.articles.invalid.project", new Object[0]))).then((user, nonNullProject) -> this.articleService.searchArticles((ApplicationUser)user, (Project)nonNullProject, query, (Iterable<String>)labels, true)).yield((user, nonNullProject, articles) -> articles).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), articles -> Response.ok((Object)new ArticleSearchResults((List<Article>)articles)).build());
    }

    @Path(value="/{issueKey}")
    @GET
    public Response getRelatedArticlesFromIssue(@PathParam(value="issueKey") String issueKey, @QueryParam(value="query") String query, @QueryParam(value="highlight") Boolean highlight) {
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        return (Response)Steps.begin(this.getLoggedinUser()).then(arg_0 -> this.lambda$getRelatedArticlesFromIssue$6((Issue)issue, arg_0)).then((user, nonNullIssue) -> {
            String nonNullQuery = (String)Option.option((Object)query).getOrElse((Object)nonNullIssue.getSummary());
            return this.articleService.searchArticlesInIssueContext((ApplicationUser)user, (Issue)nonNullIssue, nonNullQuery, (Boolean)Option.option((Object)highlight).getOrElse((Object)false));
        }).yield((user, nonNullIssue, articles) -> articles).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), articles -> Response.ok((Object)new ArticleSearchResults((List<Article>)articles)).build());
    }

    private Either<AnError, ApplicationUser> getLoggedinUser() {
        return Option.option((Object)this.jiraAuthenticationContext.getLoggedInUser()).toRight(() -> this.errorResultHelper.anError(412, "sd.knowledge.base.user.not.logged.in", new Object[0]));
    }

    private /* synthetic */ Either lambda$getRelatedArticlesFromIssue$6(Issue issue, ApplicationUser user) {
        return Option.option((Object)issue).toRight(() -> this.errorResultHelper.anError(412, "sd.knowledge.base.find.related.articles.invalid.issue", new Object[0]));
    }
}

