/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.kb.internal.listeners;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.issue.properties.IssuePropertyService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.entity.property.EntityPropertyOptions;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.event.ServiceDeskCommentEvent;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseService;
import com.atlassian.servicedesk.plugins.kb.internal.api.events.KBArticleSharedEvent;
import com.atlassian.servicedesk.plugins.kb.internal.bootstrap.featureflag.KBFeatureFlags;
import com.atlassian.servicedesk.plugins.kb.internal.listeners.KBArticleCommentShareAnalyticsEvent;
import com.atlassian.servicedesk.plugins.kb.internal.listeners.KBCommentShareChecker;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Suppliers;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KBCommentEventListener {
    private final Logger log = LoggerFactory.getLogger(KBCommentEventListener.class);
    private final IssuePropertyService issuePropertyService;
    private final AnalyticsService analyticsService;
    private final ConfluenceKnowledgeBaseService confluenceKnowledgeBaseService;
    private final ServiceDeskService serviceDeskService;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private static final String PROPERTY_PATH_KEY = "value";
    private static final EntityPropertyOptions ENTITY_PROPERTY_OPTIONS = new EntityPropertyOptions.Builder().skipPermissionChecks().build();
    private static final String KB_SHARED_PROPERTY_KEY = "sd.kb.shared";

    @Autowired
    public KBCommentEventListener(IssuePropertyService issuePropertyService, AnalyticsService analyticsService, ConfluenceKnowledgeBaseService confluenceKnowledgeBaseService, ServiceDeskService serviceDeskService, EventPublisher eventPublisher, FeatureManager featureManager, ServiceDeskPermissionService serviceDeskPermissionService) {
        this.issuePropertyService = issuePropertyService;
        this.analyticsService = analyticsService;
        this.confluenceKnowledgeBaseService = confluenceKnowledgeBaseService;
        this.serviceDeskService = serviceDeskService;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
    }

    @EventListener
    public void onServiceDeskCommentEvent(ServiceDeskCommentEvent sdCommentEvent) {
        if (KBCommentShareChecker.commentSharesKBLink(sdCommentEvent.getComment()) && sdCommentEvent.isCreatedEvent()) {
            EntityPropertyService.SetPropertyValidationResult propertyValidationResult = this.issuePropertyService.validateSetProperty(sdCommentEvent.getUser(), sdCommentEvent.getIssue().getId(), this.buildEntityProperty(), ENTITY_PROPERTY_OPTIONS);
            List<Map<String, Option<String>>> kbArticles = KBCommentShareChecker.extractKbArticles(sdCommentEvent.getComment());
            if (propertyValidationResult.isValid()) {
                this.issuePropertyService.setProperty(sdCommentEvent.getUser(), propertyValidationResult);
            } else {
                this.log.error("Failed to record kb shared event: {}", (Object)propertyValidationResult.getErrorCollection());
            }
            this.fireEvents(kbArticles, sdCommentEvent);
        }
    }

    private void fireEvents(List<Map<String, Option<String>>> kbArticles, ServiceDeskCommentEvent commentEvent) {
        ApplicationUser currentUser = commentEvent.getUser();
        Project currentProject = commentEvent.getIssue().getProjectObject();
        String issueKey = commentEvent.getIssue().getKey();
        if (this.featureManager.isEnabled(KBFeatureFlags.KB_COMMENT_SHARE_STATS_COLLECTION)) {
            Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(currentUser, currentProject))).then(serviceDesk -> StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAgent(currentUser, serviceDesk))).then((serviceDesk, isAgent) -> io.atlassian.fugue.Either.right(this.articlesToShareEvent(kbArticles, currentUser, serviceDesk.getId(), issueKey, currentProject))).yield((serviceDesk, isAgent, articles) -> {
                if (isAgent.booleanValue()) {
                    articles.forEach(article -> {
                        KBArticleSharedEvent kbArticleSharedEvent = new KBArticleSharedEvent(commentEvent.getTime().getTime(), (Map<String, Option<String>>)article);
                        this.eventPublisher.publish((Object)kbArticleSharedEvent);
                    });
                }
                return articles;
            });
        }
        this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new KBArticleCommentShareAnalyticsEvent(commentEvent.getIssue().getProjectId()));
    }

    protected boolean isArticleInCurrentKnowledgeBase(Map<String, Option<String>> article, ApplicationUser user, Project project) {
        Option result = Steps.begin(article.get("spaceKey")).then(spaceKey -> this.confluenceKnowledgeBaseService.getKBLink(user, project).toOption()).then((spaceKey, kbLink) -> Option.some((Object)StringUtils.equalsIgnoreCase((String)kbLink.getSpaceKey(), (String)spaceKey))).yield((spaceKey, kbLink, isInKb) -> isInKb);
        return (Boolean)result.getOrElse(Suppliers.alwaysFalse());
    }

    private List<Map<String, Option<String>>> articlesToShareEvent(List<Map<String, Option<String>>> articles, ApplicationUser currentUser, int serviceDeskId, String issueKey, Project currentProject) {
        HashMap commonProperties = Maps.newHashMap();
        commonProperties.put("username", Option.some((Object)currentUser.getUsername()));
        commonProperties.put("service_desk_ids", Option.some((Object)Integer.toString(serviceDeskId)));
        commonProperties.put("issueKey", Option.some((Object)issueKey));
        commonProperties.put("projectId", Option.some((Object)currentProject.getId().toString()));
        return articles.stream().map(article -> {
            HashMap shareEventArticle = Maps.newHashMap((Map)article);
            String isInCurrentKnowledgeBase = String.valueOf(this.isArticleInCurrentKnowledgeBase((Map<String, Option<String>>)article, currentUser, currentProject));
            shareEventArticle.put("inKnowledgeBase", Option.some((Object)isInCurrentKnowledgeBase));
            shareEventArticle.putAll(commonProperties);
            return shareEventArticle;
        }).collect(Collectors.toList());
    }

    private EntityPropertyService.PropertyInput buildEntityProperty() {
        JSONObject jsonObject = new JSONObject(Collections.singletonMap(PROPERTY_PATH_KEY, Boolean.toString(true)));
        return new EntityPropertyService.PropertyInput(jsonObject.toString(), KB_SHARED_PROPERTY_KEY);
    }
}

