/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.kb.internal.bootstrap.lifecycle;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.servicedesk.plugins.kb.internal.listeners.KBCommentEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class KBPluginLauncher
implements LifecycleAware {
    private final Logger log = LoggerFactory.getLogger(KBPluginLauncher.class);
    private final EventPublisher eventPublisher;
    private final KBCommentEventListener kbCommentEventListener;

    @Autowired
    public KBPluginLauncher(EventPublisher eventPublisher, KBCommentEventListener kbCommentEventListener) {
        this.eventPublisher = eventPublisher;
        this.kbCommentEventListener = kbCommentEventListener;
    }

    public void onStart() {
        this.log.info("Starting Service Desk Knowledge Base Plugin...");
        this.tenantlessSetup();
        this.log.info("Service Desk Knowledge Base Plugin started.");
    }

    public void onStop() {
        this.log.info("Stopping Service Desk Knowledge Base Plugin...");
        this.tenantlessShutdown();
        this.log.info("Service Desk Knowledge Base Plugin stopped");
    }

    private void tenantlessSetup() {
        this.eventPublisher.register((Object)this.kbCommentEventListener);
    }

    private void tenantlessShutdown() {
        this.eventPublisher.unregister((Object)this.kbCommentEventListener);
    }
}

