/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.kb.internal.article;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.plugins.kb.internal.model.Article;
import com.atlassian.servicedesk.plugins.kb.internal.search.SearchResults;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class ArticlesSearchResultsConverter {
    private final ErrorResultHelper errorResultHelper;
    private ObjectReader objectReader = new ObjectMapper().reader();
    private static final Logger logger = LoggerFactory.getLogger(ArticlesSearchResultsConverter.class);
    private static final int MAX_ARTICLES_TO_RETURN = 3;

    @Autowired
    public ArticlesSearchResultsConverter(ErrorResultHelper errorResultHelper) {
        this.errorResultHelper = errorResultHelper;
    }

    public io.atlassian.fugue.Either<AnError, List<Article>> searchResultsToArticles(SearchResults searchResults, Portal portal, ConfluenceKnowledgeBaseLink kbLink, Boolean isSufficientVersion) {
        try {
            JsonNode responseNode;
            JsonNode resultsNode;
            ArrayList articles = Lists.newArrayList();
            String resultsStr = searchResults.getResults();
            if (!StringUtils.isBlank((String)resultsStr) && (resultsNode = (responseNode = this.objectReader.readTree(resultsStr)).get("results")) != null) {
                Iterator resultsIter = resultsNode.getElements();
                while (resultsIter.hasNext() && articles.size() < 3) {
                    this.addArticleFromJsonNode(searchResults.getBaseUrl(), articles, (JsonNode)resultsIter.next(), portal, kbLink, isSufficientVersion);
                }
            }
            return io.atlassian.fugue.Either.right((Object)articles);
        }
        catch (JsonProcessingException e) {
            logger.error("Error parsing results from knowledge base server", (Throwable)e);
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(500, "sd.knowledge.base.results.parse.error", new Object[0]));
        }
        catch (IOException e) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(500, "sd.knowledge.base.results.parse.error", new Object[0]));
        }
    }

    private void addArticleFromJsonNode(String appLinkUrl, List<Article> articles, JsonNode jsonNode, Portal portal, ConfluenceKnowledgeBaseLink kbLink, Boolean isSufficientVersion) {
        boolean canShare = isSufficientVersion != false ? this.getViewPermissionFromMetaData(jsonNode) : false;
        Option.option((Object)jsonNode.get("id")).forEach(idNode -> {
            String title = (String)Option.option((Object)jsonNode.get("title")).fold(() -> "", titleNode -> titleNode.asText());
            String fullUrl = (String)Option.option((Object)jsonNode.get("url")).fold(() -> "", urlNode -> urlNode.asText());
            String bodyTextHighlights = (String)Option.option((Object)jsonNode.get("bodyTextHighlights")).fold(() -> "", bodyTextHighlightsNode -> bodyTextHighlightsNode.asText());
            articles.add(new Article(idNode.asText(), title, fullUrl, appLinkUrl, canShare, bodyTextHighlights, portal.getName(), kbLink.getSpaceKey(), kbLink.getApplicationId()));
        });
    }

    private boolean getViewPermissionFromMetaData(JsonNode jsonNode) {
        return (Boolean)Option.option((Object)jsonNode.get("metadata")).map(metaDataNode -> metaDataNode.get("userCanView")).map(userCanViewNode -> userCanViewNode.asBoolean()).getOrElse((Object)false);
    }
}

