/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.coreui.internal.utils;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.help.HelpUrlsParser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.plugins.coreui.internal.utils.HelpUrlHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class HelpUrlHelperImpl
implements HelpUrlHelper {
    private static final Logger log = LoggerFactory.getLogger(HelpUrlHelperImpl.class);
    private HelpUrlsParser helpUrlsParser;
    private HelpUrls staticLinksVar;
    private HelpUrls helpPathsVar;
    private HelpUrls kbPathsVar;

    @Autowired
    public HelpUrlHelperImpl(HelpUrlsParser helpUrlsParser) {
        this.helpUrlsParser = helpUrlsParser;
        this.staticLinksVar = helpUrlsParser.parse(this.loadProperties("sd-static-links.properties"));
        this.helpPathsVar = helpUrlsParser.parse(this.loadProperties("sd-help-paths.properties"));
        this.kbPathsVar = helpUrlsParser.parse(this.loadProperties("sd-kb-paths.properties"));
    }

    @Override
    public HelpUrls getStaticLinks() {
        return this.staticLinksVar;
    }

    @Override
    public HelpUrls getHelpPaths() {
        return this.helpPathsVar;
    }

    @Override
    public HelpUrls getKbPaths() {
        return this.kbPathsVar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(String propertiesFileLocation) {
        Properties properties = new Properties();
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)propertiesFileLocation, this.getClass());
        try {
            properties.load(is);
        }
        catch (IOException e) {
            log.error("Error loading helpfile " + propertiesFileLocation + ": " + e, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return properties;
    }
}

