/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.webhook.rulethen;

import com.atlassian.annotations.Internal;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.httpclient.api.Response;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionErrorHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.ThenAction;
import com.atlassian.servicedesk.plugins.automation.webhook.analytics.WebhookExecutedAnalyticEventSupplier;
import com.atlassian.servicedesk.plugins.automation.webhook.internal.api.AnalyticsEventDataProvider;
import com.atlassian.servicedesk.plugins.automation.webhook.internal.api.WebhookExecutor;
import com.atlassian.servicedesk.plugins.automation.webhook.internal.spi.Payload;
import com.atlassian.servicedesk.plugins.automation.webhook.internal.spi.WebhookSigner;
import com.atlassian.servicedesk.plugins.automation.webhook.rulethen.WebhookPayloadFactory;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Internal
public class WebhookThenActionHelper {
    private static final Logger log = LoggerFactory.getLogger(WebhookThenActionHelper.class);
    public static final String URL_CONFIG_KEY = "url";
    private static final String HEADERS_CONFIG_KEY = "headers";
    private static final String SEND_BODY_CONFIG_KEY = "sendBody";
    private static final WebhookSigner NOOP_WEBHOOK_SIGNER = (requestBuilder, uri) -> {};
    private final I18nHelper.BeanFactory i18nFactory;
    private final ThenActionErrorHelper thenActionErrorHelper;
    private final WebhookPayloadFactory payloadFactory;
    private final WebhookExecutor webhookExecutor;
    private final AnalyticsEventDataProvider analyticsEventDataProvider;

    @Autowired
    public WebhookThenActionHelper(I18nHelper.BeanFactory i18nFactory, ThenActionErrorHelper thenActionErrorHelper, WebhookPayloadFactory payloadFactory, WebhookExecutor webhookExecutor, AnalyticsEventDataProvider analyticsEventDataProvider) {
        this.i18nFactory = i18nFactory;
        this.thenActionErrorHelper = thenActionErrorHelper;
        this.payloadFactory = payloadFactory;
        this.webhookExecutor = webhookExecutor;
        this.analyticsEventDataProvider = analyticsEventDataProvider;
    }

    @Nonnull
    public io.atlassian.fugue.Either<ThenActionError, String> getUrlString(@Nonnull ApplicationUser user, @Nonnull ConfigurationData configurationData) {
        Assertions.notNull((String)"configurationData", (Object)configurationData);
        Assertions.notNull((String)"user", (Object)user);
        return (io.atlassian.fugue.Either)StepsConverters.newerOption((Option)configurationData.getValue(URL_CONFIG_KEY)).filter(StringUtils::isNotBlank).map(io.atlassian.fugue.Either::right).getOr(() -> StepsConverters.newerEither((Either)this.thenActionErrorHelper.error(this.i18nFactory.getInstance(user).getText("sd.action.webhook.url.missing"))));
    }

    @Nonnull
    public io.atlassian.fugue.Option<String> getUrlDescription(@Nonnull ApplicationUser user, ConfigurationData configurationData) {
        return this.getUrlString(user, configurationData).right().toOption().map(url -> this.i18nFactory.getInstance(user).getText("sd.action.webhook.vis.description", url));
    }

    public List<String> generateErrorMessage(@Nonnull ApplicationUser user, @Nonnull String i18nKey) {
        Assertions.notNull((String)"i18nKey", (Object)i18nKey);
        Assertions.notNull((String)"user", (Object)user);
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        return Lists.newArrayList((Object[])new String[]{i18nHelper.getText(i18nKey)});
    }

    public io.atlassian.fugue.Either<ThenActionError, Response> executeWebhook(ThenAction.ThenActionParam thenActionParam) {
        ConfigurationData configurationData = this.configurationData(thenActionParam);
        io.atlassian.fugue.Either<ThenActionError, String> uriEither = this.getUrlString(thenActionParam.getUser(), configurationData);
        if (uriEither.isLeft()) {
            return StepsConverters.newerEither((Either)this.thenActionErrorHelper.error((AnError)uriEither.left().get()));
        }
        String url = (String)uriEither.right().get();
        Map<String, String> headers = this.getHeaders(configurationData);
        Optional<Payload> payload = this.createPayload(configurationData, thenActionParam);
        WebhookExecutedAnalyticEventSupplier analyticsEventSupplier = this.analyticEventSupplier(thenActionParam.getMessage());
        return this.webhookExecutor.executeWebhook(url, headers, payload, NOOP_WEBHOOK_SIGNER, analyticsEventSupplier);
    }

    private WebhookExecutedAnalyticEventSupplier analyticEventSupplier(RuleMessage ruleMessage) {
        Long projectId = this.analyticsEventDataProvider.getProjectId(ruleMessage);
        Long ruleSetId = this.analyticsEventDataProvider.getRuleSetId(ruleMessage);
        return new WebhookExecutedAnalyticEventSupplier(projectId, ruleSetId);
    }

    private ConfigurationData configurationData(ThenAction.ThenActionParam thenActionParam) {
        return thenActionParam.getConfiguration().getData();
    }

    private Optional<Payload> createPayload(ConfigurationData configurationData, ThenAction.ThenActionParam thenActionParam) {
        if (this.isSendIssueBodyFlagSet(configurationData).booleanValue()) {
            Payload payload = this.payloadFactory.create(thenActionParam);
            return Optional.of(payload);
        }
        return Optional.empty();
    }

    private Boolean isSendIssueBodyFlagSet(ConfigurationData configurationData) {
        return (Boolean)configurationData.getValue(SEND_BODY_CONFIG_KEY).map(Boolean::valueOf).getOrElse((Object)false);
    }

    private Map<String, String> getHeaders(ConfigurationData configurationData) {
        return (Map)configurationData.getValue(HEADERS_CONFIG_KEY).map(this::convertHeadersJsonToMap).getOrElse(Collections.emptyMap());
    }

    private Map<String, String> convertHeadersJsonToMap(String headersJson) {
        HashMap<String, String> headers = new HashMap<String, String>();
        try {
            JSONArray jsonArray = new JSONArray(headersJson);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject json = jsonArray.getJSONObject(i);
                String name = json.getString("name");
                String value = json.getString("value");
                headers.put(name, value);
            }
        }
        catch (JSONException e) {
            log.error("Malformed WebHook request headers", (Throwable)e);
        }
        return headers;
    }
}

