/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.webhook.rulethen;

import com.atlassian.jira.issue.fields.rest.json.beans.CommentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.servicedesk.plugins.automation.webhook.internal.spi.Payload;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

class WebhookPayload
implements Payload {
    @Nullable
    private final IssueBean issue;
    @Nullable
    private final CommentJsonBean comment;
    @Nullable
    private final UserJsonBean user;
    private final Long timestamp;

    protected WebhookPayload(IssueBean issue, CommentJsonBean comment, UserJsonBean user, Long timestamp) {
        this.issue = issue;
        this.comment = comment;
        this.user = user;
        this.timestamp = (Long)Preconditions.checkNotNull((Object)timestamp);
    }

    @Override
    public IssueBean getIssue() {
        return this.issue;
    }

    @Override
    public CommentJsonBean getComment() {
        return this.comment;
    }

    @Override
    public UserJsonBean getUser() {
        return this.user;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Payload data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payload that = (Payload)o;
        return Objects.equals(this.getIssue(), that.getIssue()) && Objects.equals(this.getComment(), that.getComment()) && Objects.equals(this.getUser(), that.getUser()) && Objects.equals(this.getTimestamp(), that.getTimestamp());
    }

    public int hashCode() {
        return Objects.hash(this.getIssue(), this.getComment(), this.getUser(), this.getTimestamp());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("issue", (Object)this.getIssue()).add("comment", (Object)this.getComment()).add("user", (Object)this.getUser()).add("timestamp", (Object)this.getTimestamp()).toString();
    }

    public static final class Builder {
        private IssueBean issue;
        private CommentJsonBean comment;
        private UserJsonBean user;
        private Long timestamp;

        private Builder() {
        }

        private Builder(Payload initialData) {
            this.issue = initialData.getIssue();
            this.comment = initialData.getComment();
            this.user = initialData.getUser();
            this.timestamp = initialData.getTimestamp();
        }

        public Builder setIssue(IssueBean issue) {
            this.issue = issue;
            return this;
        }

        public Builder setComment(CommentJsonBean comment) {
            this.comment = comment;
            return this;
        }

        public Builder setUser(UserJsonBean user) {
            this.user = user;
            return this;
        }

        public Builder setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Payload build() {
            return new WebhookPayload(this.issue, this.comment, this.user, this.timestamp);
        }
    }
}

