/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.webhook.rulethen;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.jira.rest.v2.issue.IssueBeanBuilder2;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.IssueMessageHelper;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class IssueBeanFactory {
    private final IssueMessageHelper issueMessageHelper;
    private final JiraBaseUrls jiraBaseUrls;
    private final BeanBuilderFactory beanBuilderFactory;

    @Autowired
    IssueBeanFactory(IssueMessageHelper issueMessageHelper, JiraBaseUrls jiraBaseUrls, BeanBuilderFactory beanBuilderFactory) {
        this.issueMessageHelper = issueMessageHelper;
        this.jiraBaseUrls = jiraBaseUrls;
        this.beanBuilderFactory = beanBuilderFactory;
    }

    Option<IssueBean> create(RuleMessage ruleMessage) {
        return StepsConverters.newerOption((com.atlassian.fugue.Option)this.issueMessageHelper.getIssue(ruleMessage).toOption()).map(issue -> this.issueBeanBuilder().build(issue));
    }

    private IssueBeanBuilder2 issueBeanBuilder() {
        IncludedFields include = IncludedFields.includeAllByDefault((List)Lists.newArrayList());
        UriBuilder uriBuilder = UriBuilder.fromPath((String)this.jiraBaseUrls.restApi2BaseUrl());
        return this.beanBuilderFactory.newIssueBeanBuilder2(include, null, uriBuilder);
    }
}

