/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.webhook.analytics;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.IssueMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.RuleSetMessageHelper;
import com.atlassian.servicedesk.plugins.automation.webhook.internal.api.AnalyticsEventDataProvider;
import io.atlassian.fugue.Option;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
class AnalyticsEventDataProviderImpl
implements AnalyticsEventDataProvider {
    private final IssueMessageHelper issueMessageHelper;
    private final RuleSetMessageHelper ruleSetMessageHelper;

    @Autowired
    public AnalyticsEventDataProviderImpl(IssueMessageHelper issueMessageHelper, RuleSetMessageHelper ruleSetMessageHelper) {
        this.issueMessageHelper = issueMessageHelper;
        this.ruleSetMessageHelper = ruleSetMessageHelper;
    }

    @Override
    public Long getProjectId(RuleMessage ruleMessage) {
        Optional issue = StepsConverters.optionalFromOlderEither((Either)this.issueMessageHelper.getIssue(ruleMessage));
        return issue.map(Issue::getProjectId).orElse(null);
    }

    @Override
    public Long getRuleSetId(RuleMessage ruleMessage) {
        Option ruleSetId = this.ruleSetMessageHelper.getRuleSetId(ruleMessage);
        return (Long)ruleSetId.getOrElse((Object)null);
    }
}

