define("servicedesk/internal/agent/settings/automation/view/rule-settings-dialog-view", [
    "jquery",
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/util/analytics/analytics"
], function (
    $,
    Brace,
    tracker
) {

    return Brace.View.extend({
        template: ServiceDesk.Templates.Agent.Settings.ruleSetSettings,
        events: {
            "change .automation-ruleset-run-as-input": "updateRunAsUserContextModel",
            "change .automation-ruleset-trigger-from-other-rules-input": "updateTriggerFromOtherRulesModel"
        },

        updateRunAsUserContextModel: function(e) {
            var isRunAsCurrentUser = this.$(e.target).val() === 'true';
            var runAsUserContext = this.model.getMetadata().getRunAsUserContext();
            if (isRunAsCurrentUser) {
                tracker.trackEvent("automation.ruleset.edit.runasuser.select");
                runAsUserContext.set({
                    type: "currentUser"
                });
            } else {
                tracker.trackEvent("automation.ruleset.edit.runasuser.deselect");
                runAsUserContext.unset("type");
            }
            runAsUserContext.unset("user");
        },

        updateTriggerFromOtherRulesModel: function(e) {
            var triggerFromOtherRulesChecked = this.$(e.target).is(":checked");
            var metadata = this.model.getMetadata();
            if (triggerFromOtherRulesChecked) {
                tracker.trackEvent("automation.ruleset.edit.triggerfromotherrules.select");
                metadata.setTriggerFromOtherRules(true);
            } else {
                tracker.trackEvent("automation.ruleset.edit.triggerfromotherrules.deselect");
                metadata.setTriggerFromOtherRules(false);
            }
        },

        render: function() {
            var isRunAsCurrentUserValid = this.model.isUserContextCompatibleWithWhenHandlers();
            this.$el.html(this.template({
                isRunAsCurrentUserValid: isRunAsCurrentUserValid,
                metadata: this.model.getMetadata().toJSON()
            }));

            return this;
        }
    });

});