define("servicedesk/internal/agent/settings/automation/view/rule-component-details-panel-list-view", [
    "jquery",
    "automation/underscore",
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/util/trace/trace",
    "servicedesk/internal/agent/settings/automation/view/rule-component-details-panel-list-entry-view",
    "servicedesk/internal/agent/settings/automation/util/analytics/analytics"
], function (
    $,
    _,
    Brace,
    Trace,
    RuleComponentListEntryView,
    tracker
    ) {

    return Brace.View.extend({
        tagName: "ol",
        className: "component-details-configurations",
        namedEvents: [
            "closed",
            "componentRemoved",
            "editClicked"
        ],

        initialize: function () {
            this.listenTo(this.model, "remove", _.bind(this._onDelete, this));
        },

        render: function () {
            this._diposeChildren();

            var $el = this.$el;
            this.componentViews = [];
            this.model.each(_.bind(function (config) {
                var view = new RuleComponentListEntryView({
                    model: config
                }).render();

                this.listenTo(view, "editClicked", _.bind(this._onEditClicked, this));
                this.listenTo(view, "deleteClicked", _.bind(this._onDeleteClicked, this));

                $el.append(view.el);
                this.componentViews.push(view);
            }, this));

            Trace("automation.rule.component.details.panel.list.render.complete");

            return this;
        },

        hide: function() {
            this.$el.addClass("hidden");
        },

        show: function() {
            this.$el.removeClass("hidden");
        },

        focus: function () {
            if (this.componentViews && this.componentViews.length > 0) {
                this.componentViews[0].focus();
            }
        },

        _onDelete: function(model) {
            var view = this._findComponentViewFromModel(model);
            if (view) {
                var index = this.componentViews.indexOf(view);
                this.componentViews.splice(index, 1);
                this._disposeChild(view);
                this.triggerComponentRemoved();
            }
        },

        _onEditClicked: function(data) {
            this.triggerEditClicked(data);
        },

        _onDeleteClicked: function(data) {
            tracker.trackEvent("automation.ruleset.edit." + this.model.getType() + ".configuration.delete", {
                moduleKey: data.model.attributes.moduleKey
            });

            this.model.remove(data.model);
        },

        _findComponentViewFromModel: function(model) {
            return _.find(this.componentViews, function(componentView) {
                return componentView.model === model;
            });
        },

        _diposeChildren: function() {
            if (this.componentViews) {
                var disposeChild = this._disposeChild;
                _.each(this.componentViews, function(componentView) {
                    disposeChild(componentView);
                });

                this.componentViews = [];
            }
        },

        _disposeChild: function(componentView) {
            componentView.stopListening();
            componentView.undelegateEvents();
            _.defer(_.bind(componentView.dispose, componentView));
        }
    });

});