define("servicedesk/internal/agent/settings/automation/util/analytics/analytics", [
    "automation/underscore",
    "exports"
], function (
    _,
    exports
) {
    var _settings;

    exports.start = function (settings) {
        _settings = settings;
    };

    exports.stop = function () {
        _settings = null;
    };

    exports.trackEvent = function (name, data) {
        if (!_settings) {
            console.error("You must call install before tracking any events");
        }
        name = "servicedesk." + name;

        var props = _.extend({}, _settings.data, data);

        AJS.EventQueue.push( {
            name: name,
            properties: props
        });
    };
});