define("servicedesk/internal/agent/settings/automation/page/automation-rule-set-page-model", [
    "jquery",
    "automation/underscore",
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/model/rule-set-model",
    "servicedesk/internal/agent/settings/automation/util/ajax/ajax"
], function (
    $,
    _,
    Brace,
    RuleSetModel,
    Ajax
    ) {

    return Brace.Model.extend({
        namedEvents: ["fetchedFromServer", "savedOnServer", "ruleSetChanged", "validatedOnServer"],
        namedAttributes: {
            id: Number,
            projectKey: String,
            ruleSet: RuleSetModel
        },

        getUrl: function () {
            return AJS.contextPath() + "/rest/servicedesk/automation/1/ruleset/" + this.getId();
        },

        /**
         * Returns false as this model represents an existing rule set. This model is used when the user attempts to edit a rule set.
         */
        isBlueprint: function() {
            return false;
        },

        fetch: function () {
            this._pageReq = Ajax
                .get(this.getUrl())
                .done(_.bind(function (data) {
                    // userContext hack
                    if (!data.metadata) data.metadata = {};
                    if (!data.metadata.runAsUserContext) data.metadata.runAsUserContext = {};

                    this.set({
                        ruleSet: data
                    });

                    this.listenTo(this.getRuleSet(), "modelChanged", this.triggerRuleSetChanged);

                    this.triggerFetchedFromServer(data);
                }, this));

            return this._pageReq;
        },

        abort: function() {
            this._pageReq && !this._pageReq.isResolved() && this._pageReq.abort();
        }
    });

});