define("servicedesk/internal/agent/settings/automation/page/automation-list-page-model", [
    "jquery",
    "automation/underscore",
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/util/ajax/ajax",
    "servicedesk/internal/agent/settings/automation/model/rule-set-collection",
    "servicedesk/internal/agent/settings/automation/model/metadata/project-run-as-user-settings-model",
    "servicedesk/internal/agent/settings/automation/model/blueprints-collection"
], function (
    $,
    _,
    Brace,
    Ajax,
    RuleSetCollection,
    RunAsUserContextContainerModel,
    BluePrintsCollection
    ) {

    return Brace.Model.extend({
        namedEvents: ["fetchedFromServer", "modelChanged"],

        namedAttributes: {
            projectKey: String,
            sort: String,
            ruleSets: RuleSetCollection,
            projectRunAsUserSettings: RunAsUserContextContainerModel,
            blueprints: BluePrintsCollection
        },

        initialize: function() {
            this._bindEvents();
        },

        getUrl: function () {
            return AJS.contextPath() + "/rest/servicedesk/automation/1/pages/settings/automation/" + this.getProjectKey();
        },

        fetch: function () {
            this._pageReq = Ajax
                .get(this.getUrl())
                .done(_.bind(function (data) {
                    this.set(data);
                    this.triggerFetchedFromServer();
                }, this));

            return this._pageReq;
        },

        abort: function() {
            this._pageReq && !this._pageReq.isResolved() && this._pageReq.abort();
        },

        hasRuleSets: function() {
            return !!this.getRuleSets() && this.getRuleSets().length > 0
        },

        getSortedRuleSets: function() {
            var sortType = this.getSort() || "oldfirst";

            var sortingFunction = function(ruleSet) { return ruleSet; };

            switch (sortType) {
                case "name":
                    sortingFunction = function(ruleSet) {
                        return ruleSet.getName().toLowerCase();
                    };
                    break;
                case "oldfirst":
                    // Sorting by issue ID should give us the oldest first
                    sortingFunction = function(ruleSet) {
                        return ruleSet.getId();
                    };
                    break;
                case "newfirst":
                    // Sorting by the negative issue ID should give us newest first
                    sortingFunction = function(ruleSet) {
                        return -ruleSet.getId();
                    };
                    break;
            }

            // We create a new rule set collection here as sort by returns a basic array.
            return new RuleSetCollection(this.getRuleSets().sortBy(sortingFunction));
        },

        _bindEvents: function() {
            this.stopListening();

            this.listenTo(this, "change:ruleSets", _.bind(this._bindEvents, this));
        }
    });

});