define("servicedesk/internal/agent/settings/automation/page/automation-audit-log-page/automation-audit-log-page-module", [
    "jquery",
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/page/automation-audit-log-page/automation-audit-log-page-model",
    "servicedesk/internal/agent/settings/automation/page/automation-audit-log-page/automation-audit-log-page-view"
], function(
    $,
    Brace,
    AutomationAuditLogPageModel,
    AutomationAuditLogPageView
) {
    const CONTAINER_SELECTOR = ".js-automation-settings-page-container";

    return Brace.View.extend({
        template: ServiceDesk.Templates.Agent.Settings.container,

        enable: function(state, $el) {
            $el.html(this.template());
            const $container = $el.find(CONTAINER_SELECTOR);

            this.pageModel = new AutomationAuditLogPageModel({
                ruleId: state.entityId
            });

            this.pageView = new AutomationAuditLogPageView({
                model: this.pageModel,
                el: $container
            });

            return this.update();
        },

        update: function() {
            return this.pageModel.fetch().done(_.bind(function() {
                this.pageView.render();
            }, this));
        },

        disable: function() {

        }

    });
});
