define("servicedesk/internal/agent/settings/automation/page/automation-audit-log-page/automation-audit-log-page-model", [
    "jquery",
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/util/ajax/ajax",
    "servicedesk/internal/agent/settings/automation/model/rule-set-execution-summary-collection"
], function(
    $,
    Brace,
    Ajax,
    RuleSetExecutionSummaryCollection
) {
   
    return Brace.Model.extend({

        namedAttributes: {
            ruleId: Number,
            ruleName: String,
            executions: RuleSetExecutionSummaryCollection,
            issueKeyFilter: String,
            hideSuccessfulExecutions: Boolean
        },

        initialize: function () {
            this.setHideSuccessfulExecutions(false);
        },

        fetch: function() {
            return Ajax
                .get(this.getUrl())
                .done(_.bind(function(data) {
                    this.set(data);
                }, this));
        },

        getUrl: function() {
            var parts = AJS.contextPath() + "/rest/servicedesk/automation/1/audit/ruleset/" + this.getRuleId();
            if (this.getIssueKeyFilter()) {
                parts += "?issueKeyFilter=" + this.getIssueKeyFilter();
            }
            if (this.getHideSuccessfulExecutions()) {
                if (parts.indexOf("?") == -1) {
                    parts += "?hideSuccessfulExecutions=" + this.getHideSuccessfulExecutions();
                } else {
                    parts += "&hideSuccessfulExecutions=" + this.getHideSuccessfulExecutions();
                }
            }
            return parts;
        },

        getIssueKeysUrl: function() {
            return AJS.contextPath() + "/rest/servicedesk/automation/1/audit/ruleset/" + this.getRuleId() + "/issue-keys"
        }
    });
    
});
