define("servicedesk/internal/agent/settings/automation/model/validation-model", [
    "automation/backbone-brace",
    "automation/underscore"
], function (
    Brace,
    _
    ) {

    return Brace.Model.extend({
        namedAttributes: {
            globalErrors: Array,
            fieldErrors: Object
        },

        hasError: function() {
            return (this.getFieldErrors() && !_.isEmpty(this.getFieldErrors()))
                    || (this.getGlobalErrors() && this.getGlobalErrors().length > 0)
        },

        /**
         * Will add an error to the field. If the error already exists it will be ignored.
         */
        addFieldError: function(field, error) {
            var allFieldErrors = this.getFieldErrors() || {};
            var fieldErrors = allFieldErrors[field] || [];

            // Only add error if it doesn't exist
            if (!_.contains(fieldErrors, error)) {
                fieldErrors.push(error);
                allFieldErrors[field] = fieldErrors;
                this.setFieldErrors(allFieldErrors);
            }
        },

        /**
         * Will add a global error. If the error already exists it will be ignored.
         */
        addGlobalError: function(error) {
            var globalErrors = this.getGlobalErrors() || [];

            // Only add error if it doesn't exist
            if (!_.contains(globalErrors, error)) {
                globalErrors.push(error);
                this.setGlobalErrors(globalErrors);
            }
        },

        /**
         * Will remove a field error.
         */
        removeFieldError: function(field, error) {
            var allFieldErrors = this.getFieldErrors();
            if (allFieldErrors) {
                var fieldErrors = allFieldErrors[field];

                // Only add error if it doesn't exist
                if (fieldErrors && _.contains(fieldErrors, error)) {
                    fieldErrors = _.where(fieldErrors, function(e) {
                        return e !== error;
                    });

                    allFieldErrors[field] = fieldErrors;

                    this.setFieldErrors(allFieldErrors);
                }
            }
        },

        /**
         * Will remove a global error.
         */
        removeGlobalError: function(error) {
            var globalErrors = this.getGlobalErrors();

            // Only add error if it doesn't exist
            if (globalErrors && _.contains(globalErrors, error)) {
                globalErrors = _.where(globalErrors, function(e) {
                    return e !== error;
                });

                this.setGlobalErrors(globalErrors);
            }
        }
    });
});