define("servicedesk/internal/agent/settings/automation/model/then-model", [
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/model/component/then-action-collection",
    "servicedesk/internal/agent/settings/automation/model/validation-model"
], function (
    Brace,
    ThenActionCollection,
    ValidationModel
    ) {

    return Brace.Model.extend({
        namedEvents: [
            "modelChanged"
        ],
        namedAttributes: {
            thenActions: ThenActionCollection,
            validation: ValidationModel
        },

        initialize: function() {
            this._bindEvents();
        },

        getCollection: function() {
            return this.getThenActions();
        },

        getType: function() {
            return "thenAction";
        },

        serialize: function() {
            var thenActions = this.getThenActions() || new ThenActionCollection();
            
            return {
                thenActions: thenActions.map(function(thenAction) {
                    return thenAction.serialize();
                })
            }
        },

        validateStructure: function() {
            // This logic here must be the same as the structure check done on the server (see ThenValidator#validateSelf)
            var validation = this.getValidation() || new ValidationModel();

            var missingThenActionError = AJS.I18n.getText("sd.automation.rule.set.error.rule.must.contain.an.then.action");
            if (this.getThenActions().isEmpty()) {
                validation.addGlobalError(missingThenActionError);
            } else {
                validation.removeGlobalError(missingThenActionError);
            }

            // We do not need to verify the then actions as part of the structure validation.
        },

        isValid: function() {
            var isThisValid = !this.getValidation() || !this.getValidation().hasError();

            return isThisValid &&
                this.getThenActions().every(function (thenAction) {
                    return thenAction.isValid();
                });
        },

        _checkStructureAndFireChangeEvent: function() {
            this.validateStructure();
            this.triggerModelChanged();
        },

        _bindEvents: function() {
            this.stopListening();

            this.listenTo(this, "change", _.bind(this._bindEvents, this));

            this.listenTo(this.getThenActions(), "add remove", _.bind(this._checkStructureAndFireChangeEvent, this));
            this.listenTo(this.getThenActions(), "modelChanged", this.triggerModelChanged);
        }
    });

});