define("servicedesk/internal/agent/settings/automation/model/picker/when-handler-search-model", [
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/util/ajax/ajax",
    "servicedesk/internal/agent/settings/automation/model/picker/when-handler-data-list-model"
], function (
    Brace,
    Ajax,
    WhenHandlerDataListModel
    ) {

    return Brace.Model.extend({
        namedEvents: ["fetchedFromServer"],
        namedAttributes: {
            query: String,
            results: WhenHandlerDataListModel
        },

        getUrl: function () {
            return AJS.contextPath() + "/rest/servicedesk/automation/1/components/when";
        },

        search: function(query) {
            this._pageReq = Ajax
                .get(this.getUrl())
                .done(_.bind(function (data) {
                    this.set({
                        query: query,
                        results: data
                    });
                    this.triggerFetchedFromServer();
                }, this));

            return this._pageReq;
        },

        abort: function() {
            this._pageReq && !this._pageReq.isResolved() && this._pageReq.abort();
        },

        // Filters the result collection given the current state of the rule components
        // ruleModel: The rule model that is NOT JSON-ified
        getCompatibleResultCollection: function(ruleModel) {
            var whens = this.getResults().getCollection() || [];

            whens = this._filterUniqueWhenHandlers(whens, ruleModel);
            whens = this._filterIncompatibleWhenHandlers(whens, ruleModel);

            return whens;
        },

        _filterUniqueWhenHandlers: function(whens, ruleModel) {
            var whenKeysInRule = ruleModel.getWhen().getWhenHandlers().map(function(when) {
                return when.getModuleKey();
            });

            return whens.filter(function(when) {
                return !(when.getUnique() && _.contains(whenKeysInRule, when.getModuleKey()));
            });
        },

        _filterIncompatibleWhenHandlers: function(whens, ruleModel) {
            var ifThenRequireUnion = [];

            ruleModel.getIfThens().each(function(ifThen) {
                ifThen.getIf().getCollection().each(function(ifCondition) {
                    ifThenRequireUnion = _.union(ifCondition.getRequires(), ifThenRequireUnion);
                });

                ifThen.getThen().getCollection().each(function(thenAction) {
                    ifThenRequireUnion = _.union(thenAction.getRequires(), ifThenRequireUnion);
                });
            });

            ifThenRequireUnion = _.uniq(ifThenRequireUnion);
            return whens.filter(function(when) {
                return when.isCompatibleWith(ifThenRequireUnion);
            })
        }
    });

});