define("servicedesk/internal/agent/settings/automation/model/picker/then-action-search-model", [
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/util/ajax/ajax",
    "servicedesk/internal/agent/settings/automation/model/picker/then-action-data-list-model"
], function (
    Brace,
    Ajax,
    ThenActionDataListModel
    ) {

    return Brace.Model.extend({
        namedEvents: ["fetchedFromServer"],
        namedAttributes: {
            query: String,
            results: ThenActionDataListModel
        },

        getUrl: function () {
            return AJS.contextPath() + "/rest/servicedesk/automation/1/components/then";
        },

        search: function(query) {
            this._pageReq = Ajax
                .get(this.getUrl())
                .done(_.bind(function (data) {
                    this.set({
                        query: query,
                        results: data
                    });
                    this.triggerFetchedFromServer();
                }, this));

            return this._pageReq;
        },

        abort: function() {
            this._pageReq && !this._pageReq.isResolved() && this._pageReq.abort();
        },

        // Filters the result collection given the current state of the rule components
        // ruleModel: The rule model that is NOT JSON-ified
        getCompatibleResultCollection: function(ruleModel) {
            var whenProvidesIntersect;

            ruleModel.getWhen().getCollection().each(function(when) {
                var whenProvides = when.getProvides() || [];

                if (whenProvidesIntersect) {
                    whenProvidesIntersect = _.intersection(whenProvidesIntersect, _.uniq(whenProvides));
                } else {
                    whenProvidesIntersect = _.uniq(whenProvides);
                }
            });

            var results = this.getResults().getCollection() || [];
            return results.filter(function(result) {
                return result.isCompatibleWith(whenProvidesIntersect);
            })
        }
    });

});