define("servicedesk/internal/agent/settings/automation/model/metadata/metadata-model", [
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/model/metadata/project-context-model",
    "servicedesk/internal/agent/settings/automation/model/metadata/run-as-user-context-model",
    "servicedesk/internal/agent/settings/automation/model/metadata/user-context-model"
], function (
    Brace,
    ProjectContextModel,
    RunAsUserContextModel,
    UserContextModel
    ) {

    return Brace.Model.extend({
        namedEvents: ["modelChanged"],
        namedAttributes: {
            runAsUserContext: RunAsUserContextModel,
            projectContext: ProjectContextModel,
            triggerFromOtherRules: Boolean,
            projectRunAsUser: UserContextModel
        },

        defaults: {
            runAsUserContext: new RunAsUserContextModel(),
            projectContext: new ProjectContextModel(),
            triggerFromOtherRules: true
        },

        initialize: function() {
            this._bindEvents();
        },

        serialize: function() {
            return {
                projectContext: this.getProjectContext().serialize(),
                runAsUserContext: this.getRunAsUserContext().serialize(),
                triggerFromOtherRules: this.getTriggerFromOtherRules()
            };
        },

        _bindEvents: function() {
            this.stopListening();

            this.listenTo(this, "change", _.bind(this._bindEvents, this));

            this.listenTo(this.getRunAsUserContext(), "change", this.triggerModelChanged);
            this.listenTo(this.getProjectContext(), "change", this.triggerModelChanged);
            this.listenTo(this, "change:triggerFromOtherRules", this.triggerModelChanged);
        }
    });

});