define("servicedesk/internal/agent/settings/automation/model/if-then-model", [
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/model/if-model",
    "servicedesk/internal/agent/settings/automation/model/then-model",
    "servicedesk/internal/agent/settings/automation/model/validation-model"
], function (
    Brace,
    IfModel,
    ThenModel,
    ValidationModel
    ) {

    return Brace.Model.extend({
        namedEvents: [
            "modelChanged",
            "requestValidateStructure"
        ],
        namedAttributes: {
            "if": IfModel,
            then: ThenModel,
            validation: ValidationModel
        },

        initialize: function() {
            this._bindEvents();
        },

        serialize: function() {
            var ruleIf = this.getIf() || new IfModel();
            var then = this.getThen() || new ThenModel();
            
            return {
                "if": ruleIf.serialize(),
                then: then.serialize()
            }
        },

        validateStructure: function(isLast) {
            // This logic here must be the same as the structure check done on the server (see IfThenValidator#validateSelf)
            // There are currently no failure states

            this.getIf().validateStructure(isLast);
            this.getThen().validateStructure();
        },

        isValid: function() {
            var isThisValid = !this.getValidation() || !this.getValidation().hasError();

            return isThisValid &&
                this.getIf().isValid() &&
                this.getThen().isValid();
        },

        _bindEvents: function() {
            this.stopListening();

            this.listenTo(this, "change", _.bind(this._bindEvents, this));

            this.listenTo(this.getIf(), "modelChanged", this.triggerModelChanged);
            this.listenTo(this.getIf(), "requestValidateStructure", _.bind(this.triggerRequestValidateStructure, this, this));
            this.listenTo(this.getThen(), "modelChanged", this.triggerModelChanged);
        }
    });

});