define("servicedesk/internal/agent/settings/automation/model/if-model", [
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/model/component/if-condition-collection",
    "servicedesk/internal/agent/settings/automation/model/validation-model"
], function (
    Brace,
    IfConditionCollection,
    ValidationModel
    ) {

    return Brace.Model.extend({
        namedEvents: [
            "modelChanged",
            "requestValidateStructure"
        ],
        namedAttributes: {
            ifConditions: IfConditionCollection,
            validation: ValidationModel
        },

        initialize: function() {
            this._bindEvents();
        },

        getCollection: function() {
            return this.getIfConditions();
        },

        getType: function() {
            return "ifCondition";
        },

        serialize: function() {
            var ifConditions = this.getIfConditions() || new IfConditionCollection();
            
            return {
                ifConditions: ifConditions.map(function(ifCondition) {
                    return ifCondition.serialize();
                })
            }
        },

        validateStructure: function(isLast) {
            // This logic here must be the same as the structure check done on the server (see IfValidator#validateSelf)
            var validation = this.getValidation();

            // This is a bit hacky as the if-model has no concept of whether it is last in a collection, use
            // this.triggerRequestValidateStructure(this) to execute this method from the if-model.
            var missingIfConditionError = AJS.I18n.getText("sd.automation.rule.set.error.if.condition.can.not.be.empty");
            if (!isLast && (!this.getIfConditions() || this.getIfConditions().isEmpty())) {
                validation.addGlobalError(missingIfConditionError);
            } else {
                validation.removeGlobalError(missingIfConditionError);
            }

            // We do not need to verify the if conditions as part of the structure validation.
        },

        isValid: function() {
            var isThisValid = !this.getValidation() || !this.getValidation().hasError();

            return isThisValid &&
                this.getIfConditions().every(function (ifConditions) {
                    return ifConditions.isValid();
                });
        },

        _checkStructureAndFireChangeEvent: function() {
            this.triggerRequestValidateStructure(this); // This will cause the validateStructure to be called with isLast parameter
            this.triggerModelChanged();
        },

        _bindEvents: function() {
            this.stopListening();

            this.listenTo(this, "change", _.bind(this._bindEvents, this));

            this.listenTo(this.getIfConditions(), "add remove", _.bind(this._checkStructureAndFireChangeEvent, this));
            this.listenTo(this.getIfConditions(), "modelChanged", this.triggerModelChanged);
        }
    });

});