define("servicedesk/internal/agent/settings/automation/model/component/when-handler-model", [
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/model/validation-model",
    "servicedesk/internal/agent/settings/automation/util/ajax/ajax"
], function (
    Brace,
    ValidationModel,
    Ajax
    ) {

    return Brace.Model.extend({
        namedEvents: [
            "modelChanged"
        ],
        namedAttributes: {
            name: String,
            label: String,
            iconClass: String,
            moduleKey: String,
            webFormModule: String,
            data: Object,
            validation: ValidationModel,
            provides: Array,
            unique: Boolean
        },
        getValidateUrl: function() {
            return AJS.contextPath() + "/rest/servicedesk/automation/1/components/when/" + AJS.Meta.get("projectKey") + "/validate";
        },

        getType: function() {
            return "whenHandler";
        },

        validateConfiguration: function(serializedConfig) {
            return Ajax.post(this.getValidateUrl(), serializedConfig);
        },

        initialize: function() {
            this._bindEvents();
        },

        // Checks whether this particular condition is compatible with the given list of
        // provided types
        isCompatibleWith: function(requires) {
            var provides = this.getProvides() || [];
            var uniqueRequires = _.uniq(requires);

            return uniqueRequires.length === _.intersection(uniqueRequires, provides).length;
        },

        // We need to serialize this instead of just converting the whole model into JSON because
        // Jackson does not allow additional parameters in the request.
        serialize: function() {
            return {
                moduleKey: this.getModuleKey(),
                data: this.getData()
            }
        },

        isValid: function() {
            return !this.getValidation() || !this.getValidation().hasError();
        },

        _bindEvents: function() {
            this.stopListening();

            this.listenTo(this, "change", _.bind(this._bindEvents, this));

            this.listenTo(this, "change:data", this.triggerModelChanged);
        }
    });

});