define("servicedesk/internal/agent/settings/automation/model/blueprint-detail-model", [
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/util/ajax/ajax",
    "servicedesk/internal/agent/settings/automation/model/rule-collection",
    "servicedesk/internal/agent/settings/automation/model/validation-model",
    "servicedesk/internal/agent/settings/automation/model/metadata/metadata-model",
    "servicedesk/internal/agent/settings/automation/model/help-model",
    "servicedesk/internal/agent/settings/automation/model/rule-set-model"
], function (
    Brace,
    Ajax,
    RuleCollection,
    ValidationModel,
    MetadataModel,
    HelpModel,
    RuleSetModel
) {

    // This is a copy of the rule set model without the event and has some extra fields.
    // This behaves like a template for the rule set model and can be used to create a rule set model.
    return Brace.Model.extend({
        namedAttributes: {
            name: String,
            description: String,
            help: HelpModel,
            rules: RuleCollection,
            metadata: MetadataModel,
            validation: ValidationModel
        },

        defaults: {
            metadata: new MetadataModel()
        },

        createRuleSetModel: function() {
            // All this does at the moment is delete the name and help
            var rawBlueprint = this.toJSON();
            delete rawBlueprint.name;
            delete rawBlueprint.help;

            return new RuleSetModel(rawBlueprint);
        }
    });

});